/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ParseUtil;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final String READ = "Read {}";
    private static final String READING_FILE = "Reading file {}";
    private static final String ERROR_READING_FILE = "Error reading file {}. {}";
    private static final String ERROR_CLOSING_FILE = "Error closing file {}. {}";

    private FileUtil() {
    }

    public static List<String> readFile(String filename) {
        return FileUtil.readFile(filename, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> readFile(String filename, boolean reportError) {
        ArrayList<String> lines = new ArrayList<String>();
        File file = new File(filename);
        if (file.canRead()) {
            LOG.debug(READING_FILE, (Object)filename);
            BufferedReader br = null;
            InputStreamReader isr = null;
            FileInputStream fis = null;
            try {
                String line;
                fis = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fis, ParseUtil.UTF_8);
                br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                return lines;
            }
            catch (IOException e) {
                if (!reportError) return lines;
                LOG.error(ERROR_READING_FILE, (Object)filename, (Object)e.getMessage());
                return lines;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error(ERROR_CLOSING_FILE, (Object)filename, (Object)ex.getMessage());
                }
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error(ERROR_CLOSING_FILE, (Object)filename, (Object)ex.getMessage());
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error(ERROR_CLOSING_FILE, (Object)filename, (Object)ex.getMessage());
                }
            }
        }
        if (!reportError) return lines;
        LOG.warn("File not found or not readable: {}", (Object)filename);
        return lines;
    }

    public static long getLongFromFile(String filename) {
        List<String> read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_FILE, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ, (Object)read.get(0));
            }
            return ParseUtil.parseLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static long getUnsignedLongFromFile(String filename) {
        List<String> read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_FILE, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ, (Object)read.get(0));
            }
            return ParseUtil.parseUnsignedLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static int getIntFromFile(String filename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_FILE, (Object)filename);
        }
        try {
            List<String> read = FileUtil.readFile(filename, false);
            if (!read.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(READ, (Object)read.get(0));
                }
                return Integer.parseInt(read.get(0));
            }
        }
        catch (NumberFormatException ex) {
            LOG.warn("Unable to read value from {}. {}", (Object)filename, (Object)ex);
        }
        return 0;
    }

    public static String getStringFromFile(String filename) {
        List<String> read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_FILE, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ, (Object)read.get(0));
            }
            return read.get(0);
        }
        return "";
    }

    public static Map<String, String> getKeyValueMapFromFile(String filename, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_FILE, (Object)filename);
        }
        List<String> lines = FileUtil.readFile(filename, false);
        for (String line : lines) {
            String[] parts = line.split(separator);
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1].trim());
        }
        return map;
    }
}

