/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private long memFree = 0L;
    private long activeFile = 0L;
    private long inactiveFile = 0L;
    private long sReclaimable = 0L;
    private long swapFree = 0L;
    private long lastUpdate = 0L;

    public LinuxGlobalMemory() {
        this.pageSize = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    }

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            String[] memorySplit;
            List<String> memInfo = FileUtil.readFile("/proc/meminfo");
            boolean found = false;
            for (String checkLine : memInfo) {
                memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                if (memorySplit[0].equals("MemTotal:")) {
                    this.memTotal = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (memorySplit[0].equals("MemFree:")) {
                    this.memFree = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (memorySplit[0].equals("MemAvailable:")) {
                    this.memAvailable = this.parseMeminfo(memorySplit);
                    found = true;
                    continue;
                }
                if (memorySplit[0].equals("Active(file):")) {
                    this.activeFile = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (memorySplit[0].equals("Inactive(file):")) {
                    this.inactiveFile = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (memorySplit[0].equals("SReclaimable:")) {
                    this.sReclaimable = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (memorySplit[0].equals("SwapTotal:")) {
                    this.swapTotal = this.parseMeminfo(memorySplit);
                    continue;
                }
                if (!memorySplit[0].equals("SwapFree:")) continue;
                this.swapFree = this.parseMeminfo(memorySplit);
            }
            this.swapUsed = this.swapTotal - this.swapFree;
            if (!found) {
                this.memAvailable = this.memFree + this.activeFile + this.inactiveFile + this.sReclaimable;
            }
            memInfo = FileUtil.readFile("/proc/vmstat");
            for (String checkLine : memInfo) {
                memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                if (memorySplit[0].equals("pgpgin")) {
                    this.swapPagesIn = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                    continue;
                }
                if (!memorySplit[0].equals("pgpgout")) continue;
                this.swapPagesOut = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
            }
            this.lastUpdate = now;
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }
}

