/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class URLSpec {
    private URL mUrl;
    private Proxy mProxy;

    public URLSpec(String url) throws MalformedURLException {
        this.mUrl = new URL(url);
    }

    public URLSpec(URL url) {
        this.mUrl = url;
    }

    public URLSpec(String url, String host, int port) throws MalformedURLException {
        this.mUrl = new URL(url);
        if (host != null) {
            this.mProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
    }

    public URLSpec(String url, Proxy proxy) throws MalformedURLException {
        this.mUrl = new URL(url);
        this.mProxy = proxy;
    }

    public URLSpec(URL url, Proxy proxy) {
        this.mUrl = url;
        this.mProxy = proxy;
    }

    public URLConnection openConnection() throws IOException {
        if (this.mProxy == null) {
            return this.mUrl.openConnection();
        }
        return this.mUrl.openConnection(this.mProxy);
    }

    public String toString() {
        if (this.mProxy == null) {
            return this.mUrl.toString();
        }
        return this.mUrl.toString() + " [" + this.mProxy + "]";
    }
}

