/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.wxopen.TemplateAddResult;
import weixin.popular.bean.wxopen.TemplateLibraryGetResult;
import weixin.popular.bean.wxopen.TemplateLibraryListResult;
import weixin.popular.bean.wxopen.TemplateListResult;
import weixin.popular.bean.wxopen.Wxamplink;
import weixin.popular.bean.wxopen.WxamplinkgetResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class WxopenAPI
extends BaseAPI {
    public static WxamplinkgetResult wxamplinkget(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/wxamplinkget").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, WxamplinkgetResult.class);
    }

    public static BaseResult wxamplink(String access_token, Wxamplink wxamplink) {
        String json = JsonUtil.toJSONString(wxamplink);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/wxamplink").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult wxampunlink(String access_token, String appid) {
        String json = String.format("{\"appid\":\"%s\"}", appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/wxampunlink").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static TemplateLibraryListResult templateLibraryList(String access_token, int offset, int count) {
        String json = String.format("{\"offset\":%d,\"count\":%d}", offset, count);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/template/library/list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TemplateLibraryListResult.class);
    }

    public static TemplateLibraryGetResult templateLibraryGet(String access_token, String id) {
        String json = String.format("{\"id\":\"%s\"}", id);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TemplateLibraryGetResult.class);
    }

    public static TemplateAddResult templateAdd(String access_token, String id, List<Integer> keyword_id_list) {
        String json = String.format("{\"id\":\"%s\",\"keyword_id_list\":%s}", id, JsonUtil.toJSONString(keyword_id_list));
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/template/add").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TemplateAddResult.class);
    }

    public static TemplateListResult templateList(String access_token, int offset, int count) {
        String json = String.format("{\"offset\":%d,\"count\":%d}", offset, count);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/template/list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TemplateListResult.class);
    }

    public static BaseResult templateDel(String access_token, String template_id) {
        String json = String.format("{\"template_id\":\"%s\"}", template_id);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxopen/template/del").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }
}

