/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

public class API {
    private static final String KEY_JOIN = "#";
    private static APIHandler apiHandler;

    private static boolean isKeyParam(String keyParam) {
        return keyParam != null && keyParam.length() < 50;
    }

    public static String keyParam(String component_appid, String authorizer_appid) {
        return String.format("%s%s%s", component_appid, KEY_JOIN, authorizer_appid);
    }

    public static String accessToken(String key) {
        if (API.isKeyParam(key)) {
            String[] keys = key.split(KEY_JOIN);
            if (keys.length == 2) {
                return apiHandler.accessToken(keys[0], keys[1]);
            }
            if (keys.length == 1) {
                return apiHandler.accessToken(keys[0]);
            }
        }
        return key;
    }

    public static String componentAccessToken(String key) {
        if (API.isKeyParam(key)) {
            return apiHandler.componentAccessToken(key);
        }
        return key;
    }

    public static String ticket(String key, String type) {
        if (API.isKeyParam(key)) {
            String[] keys = key.split(KEY_JOIN);
            if (keys.length == 2) {
                return apiHandler.ticket(keys[0], keys[1], type);
            }
            if (keys.length == 1) {
                return apiHandler.ticket(keys[0], type);
            }
        }
        return key;
    }

    public static APIHandler getApiHandler() {
        return apiHandler;
    }

    public static void setApiHandler(APIHandler apiHandler) {
        API.apiHandler = apiHandler;
    }

    public static interface APIHandler {
        public String accessToken(String var1, String var2);

        public String accessToken(String var1);

        public String componentAccessToken(String var1);

        public String ticket(String var1, String var2, String var3);

        public String ticket(String var1, String var2);
    }
}

