/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import java.util.HashMap;
import java.util.Map;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StyleSheet {
    private final Map<String, Map<String, String>> classMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> tagMap = new HashMap<String, Map<String, String>>();

    public void applyStyle(String tag, Map<String, String> props) {
        String cm;
        Map<String, String> map = this.tagMap.get(tag.toLowerCase());
        if (map != null) {
            HashMap<String, String> temp = new HashMap<String, String>(map);
            temp.putAll(props);
            props.putAll(temp);
        }
        if ((cm = props.get("class")) == null) {
            return;
        }
        map = this.classMap.get(cm.toLowerCase());
        if (map == null) {
            return;
        }
        props.remove("class");
        HashMap<String, String> temp = new HashMap<String, String>(map);
        temp.putAll(props);
        props.putAll(temp);
    }

    public void loadStyle(String style, Map<String, String> props) {
        this.classMap.put(style.toLowerCase(), props);
    }

    public void loadStyle(String style, String key, String value) {
        style = style.toLowerCase();
        Map props = this.classMap.computeIfAbsent(style, k -> new HashMap());
        props.put(key, value);
    }

    public void loadTagStyle(String tag, Map<String, String> props) {
        this.tagMap.put(tag.toLowerCase(), props);
    }

    public void loadTagStyle(String tag, String key, String value) {
        tag = tag.toLowerCase();
        Map props = this.tagMap.computeIfAbsent(tag, k -> new HashMap());
        props.put(key, value);
    }
}

