/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.watermark.FontImage;
import com.github.liaochong.myexcel.core.watermark.Watermark;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WatermarkUtil {
    public static void addWatermark(Workbook workbook, String text) {
        Watermark watermark = new Watermark();
        watermark.setText(text);
        WatermarkUtil.addWatermark(workbook, watermark);
    }

    public static void addWatermark(Workbook workbook, Watermark watermark) {
        if (watermark == null) {
            return;
        }
        try {
            if (workbook instanceof HSSFWorkbook) {
                throw new ExcelBuildException("Watermark can only be provided to XSSFWork.");
            }
            BufferedImage image = FontImage.createWatermarkImage(watermark);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", os);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            XSSFWorkbook xssfWorkbook = workbook instanceof SXSSFWorkbook ? ((SXSSFWorkbook)workbook).getXSSFWorkbook() : (XSSFWorkbook)workbook;
            workbook = xssfWorkbook;
            int pictureIdx = workbook.addPicture(os.toByteArray(), 6);
            POIXMLDocumentPart poixmlDocumentPart = (POIXMLDocumentPart)xssfWorkbook.getAllPictures().get(pictureIdx);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                XSSFSheet sheet = xssfWorkbook.getSheetAt(i);
                PackagePartName ppn = poixmlDocumentPart.getPackagePart().getPartName();
                String relType = XSSFRelation.IMAGES.getRelation();
                PackageRelationship pr = sheet.getPackagePart().addRelationship(ppn, TargetMode.INTERNAL, relType, null);
                sheet.getCTWorksheet().addNewPicture().setId(pr.getId());
            }
        }
        catch (Exception e) {
            WatermarkUtil.clear(workbook);
            throw new ExcelBuildException("Failed to add watermark", e);
        }
    }

    private static void clear(Workbook workbook) {
        if (workbook == null) {
            return;
        }
        if (workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)workbook).dispose();
        }
        try {
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

