/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.annotation.MultiColumn;
import com.github.liaochong.myexcel.core.constant.Constants;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class MultiWriteConverter
implements WriteConverter {
    public final List<Pair<Class, WriteConverter>> writeConverterContainer;

    public MultiWriteConverter(List<Pair<Class, WriteConverter>> writeConverterContainer) {
        this.writeConverterContainer = new LinkedList<Pair<Class, WriteConverter>>(writeConverterContainer);
    }

    @Override
    public Pair<Class, Object> convert(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        MultiColumn multiColumn = field.getAnnotation(MultiColumn.class);
        LinkedList<Pair<Class, Object>> result = new LinkedList<Pair<Class, Object>>();
        for (Object o : (List)fieldVal) {
            if (o == null) {
                result.add(Constants.NULL_PAIR);
                continue;
            }
            WriteConverter writeConverter = WriteConverterContext.getWriteConverter(field, multiColumn.classType(), o, convertContext, this.writeConverterContainer);
            Pair<Class, Object> convertResult = writeConverter.convert(field, multiColumn.classType(), o, convertContext);
            result.add(convertResult);
        }
        return result.isEmpty() ? Constants.NULL_PAIR : Pair.of(multiColumn.classType(), result);
    }

    @Override
    public boolean support(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        return field.isAnnotationPresent(MultiColumn.class) && field.getType() == List.class;
    }
}

