/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.CsvReadHandler;
import com.github.liaochong.myexcel.core.HSSFSaxReadHandler;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.ReadOnlySharedStringsTable;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.RowContext;
import com.github.liaochong.myexcel.core.XSSFSaxReadHandler;
import com.github.liaochong.myexcel.core.XSSFSheetXMLHandler;
import com.github.liaochong.myexcel.core.cache.StringsCache;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxExcelReader<T> {
    private static final int DEFAULT_SHEET_INDEX = 0;
    private static final Logger log = LoggerFactory.getLogger(SaxExcelReader.class);
    private final List<T> result = new LinkedList<T>();
    private final ReadConfig<T> readConfig = new ReadConfig(0);

    private SaxExcelReader(Class<T> dataType) {
        ((ReadConfig)this.readConfig).dataType = dataType;
    }

    public static <T> SaxExcelReader<T> of(Class<T> clazz) {
        return new SaxExcelReader<T>(clazz);
    }

    public SaxExcelReader<T> sheet(Integer sheetIndex) {
        return this.sheets(sheetIndex);
    }

    public SaxExcelReader<T> sheet(String sheetName) {
        return this.sheets(sheetName);
    }

    public SaxExcelReader<T> sheets(Integer ... sheetIndexs) {
        ((ReadConfig)this.readConfig).sheetIndexs.clear();
        ((ReadConfig)this.readConfig).sheetIndexs.addAll(Arrays.asList(sheetIndexs));
        return this;
    }

    public SaxExcelReader<T> sheets(String ... sheetNames) {
        ((ReadConfig)this.readConfig).sheetNames.clear();
        ((ReadConfig)this.readConfig).sheetNames.addAll(Arrays.asList(sheetNames));
        return this;
    }

    public SaxExcelReader<T> rowFilter(Predicate<Row> rowFilter) {
        ((ReadConfig)this.readConfig).rowFilter = rowFilter;
        return this;
    }

    public SaxExcelReader<T> beanFilter(Predicate<T> beanFilter) {
        ((ReadConfig)this.readConfig).beanFilter = beanFilter;
        return this;
    }

    public SaxExcelReader<T> charset(String charset) {
        ((ReadConfig)this.readConfig).charset = charset;
        return this;
    }

    public SaxExcelReader<T> exceptionally(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        ((ReadConfig)this.readConfig).exceptionFunction = exceptionFunction;
        return this;
    }

    public SaxExcelReader<T> noTrim() {
        ((ReadConfig)this.readConfig).trim = v -> v;
        return this;
    }

    public SaxExcelReader<T> readAllSheet() {
        ((ReadConfig)this.readConfig).readAllSheet = true;
        return this;
    }

    public SaxExcelReader<T> startSheet(BiConsumer<String, Integer> startSheetConsumer) {
        ((ReadConfig)this.readConfig).startSheetConsumer = startSheetConsumer;
        return this;
    }

    public List<T> read(InputStream fileInputStream) {
        this.doRead(fileInputStream);
        return this.result;
    }

    public List<T> read(File file) {
        this.doRead(file);
        return this.result;
    }

    public void readThen(InputStream fileInputStream, Consumer<T> consumer) {
        ((ReadConfig)this.readConfig).consumer = consumer;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, Consumer<T> consumer) {
        ((ReadConfig)this.readConfig).consumer = consumer;
        this.doRead(file);
    }

    public void readThen(InputStream fileInputStream, BiConsumer<T, RowContext> contextConsumer) {
        ((ReadConfig)this.readConfig).contextConsumer = contextConsumer;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, BiConsumer<T, RowContext> contextConsumer) {
        ((ReadConfig)this.readConfig).contextConsumer = contextConsumer;
        this.doRead(file);
    }

    public void readThen(InputStream fileInputStream, Function<T, Boolean> function) {
        ((ReadConfig)this.readConfig).function = function;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, BiFunction<T, RowContext, Boolean> contextFunction) {
        ((ReadConfig)this.readConfig).contextFunction = contextFunction;
        this.doRead(file);
    }

    public void readThen(InputStream fileInputStream, BiFunction<T, RowContext, Boolean> contextFunction) {
        ((ReadConfig)this.readConfig).contextFunction = contextFunction;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, Function<T, Boolean> function) {
        ((ReadConfig)this.readConfig).function = function;
        this.doRead(file);
    }

    private void doRead(InputStream fileInputStream) {
        Path path = TempFileOperator.convertToFile(fileInputStream);
        try {
            this.doRead(path.toFile());
        }
        finally {
            TempFileOperator.deleteTempFile(path);
        }
    }

    private void doRead(File file) {
        FileMagic fm;
        try (InputStream is = FileMagic.prepareToCheckMagic((InputStream)new FileInputStream(file));){
            fm = FileMagic.valueOf((InputStream)is);
        }
        catch (Throwable throwable) {
            throw new SaxReadException("Fail to get excel magic", throwable);
        }
        try {
            switch (fm) {
                case OOXML: {
                    this.doReadXlsx(file);
                    break;
                }
                case OLE2: {
                    this.doReadXls(file);
                    break;
                }
                default: {
                    this.doReadCsv(file);
                    break;
                }
            }
        }
        catch (Throwable e) {
            throw new SaxReadException("Fail to read excel", e);
        }
    }

    private void doReadXls(File file) {
        try {
            new HSSFSaxReadHandler<T>(file, this.result, this.readConfig).process();
        }
        catch (StopReadException stopReadException) {
        }
        catch (IOException e) {
            throw new SaxReadException("Fail to read xls file:" + file.getName(), e);
        }
    }

    private void doReadXlsx(File file) {
        try (OPCPackage p2 = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            this.process(p2);
        }
        catch (StopReadException p2) {
        }
        catch (Exception e) {
            throw new SaxReadException("Fail to read xlsx file:" + file.getName(), e);
        }
    }

    private void doReadCsv(File file) {
        try {
            new CsvReadHandler<T>(Files.newInputStream(file.toPath(), new OpenOption[0]), this.readConfig, this.result).read();
        }
        catch (StopReadException stopReadException) {
        }
        catch (Throwable throwable) {
            throw new ExcelReadException("Fail to read csv file:" + file.getName(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(OPCPackage xlsxPackage) throws IOException, OpenXML4JException, SAXException {
        long startTime;
        block43: {
            startTime = System.currentTimeMillis();
            StringsCache stringsCache = new StringsCache();
            try {
                ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(xlsxPackage, stringsCache);
                XSSFReader xssfReader = new XSSFReader(xlsxPackage);
                XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
                int index = 0;
                if (((ReadConfig)this.readConfig).readAllSheet) {
                    while (iter.hasNext()) {
                        try (InputStream stream = iter.next();){
                            ((ReadConfig)this.readConfig).startSheetConsumer.accept(iter.getSheetName(), index);
                            this.processSheet(strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig), stream);
                        }
                        ++index;
                    }
                    break block43;
                }
                if (!((ReadConfig)this.readConfig).sheetNames.isEmpty()) {
                    while (iter.hasNext()) {
                        InputStream stream = iter.next();
                        Throwable throwable = null;
                        try {
                            if (((ReadConfig)this.readConfig).sheetNames.contains(iter.getSheetName())) {
                                ((ReadConfig)this.readConfig).startSheetConsumer.accept(iter.getSheetName(), index);
                                this.processSheet(strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig), stream);
                            }
                            ++index;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    break block43;
                }
                while (iter.hasNext()) {
                    InputStream stream = iter.next();
                    Throwable throwable = null;
                    try {
                        if (((ReadConfig)this.readConfig).sheetIndexs.contains(index)) {
                            ((ReadConfig)this.readConfig).startSheetConsumer.accept(iter.getSheetName(), index);
                            this.processSheet(strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig), stream);
                        }
                        ++index;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            finally {
                stringsCache.clearAll();
            }
        }
        log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void processSheet(SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(null, null, strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public static final class ReadConfig<T> {
        private Class<T> dataType;
        private Set<String> sheetNames = new HashSet<String>();
        private Set<Integer> sheetIndexs = new HashSet<Integer>();
        private Consumer<T> consumer;
        private BiConsumer<T, RowContext> contextConsumer;
        private Function<T, Boolean> function;
        private BiFunction<T, RowContext, Boolean> contextFunction;
        private Predicate<Row> rowFilter = row -> true;
        private Predicate<T> beanFilter = bean -> true;
        private BiFunction<Throwable, ReadContext, Boolean> exceptionFunction = (t, c) -> false;
        private String charset = "UTF-8";
        private Function<String, String> trim = v -> {
            if (v == null) {
                return v;
            }
            return v.trim();
        };
        private boolean readAllSheet;
        private BiConsumer<String, Integer> startSheetConsumer = (sheetName, sheetIndex) -> log.info("Start read excel, sheet:{},index:{}", sheetName, sheetIndex);

        public ReadConfig(int sheetIndex2) {
            this.sheetIndexs.add(sheetIndex2);
        }

        public Class<T> getDataType() {
            return this.dataType;
        }

        public Set<String> getSheetNames() {
            return this.sheetNames;
        }

        public Set<Integer> getSheetIndexs() {
            return this.sheetIndexs;
        }

        public Consumer<T> getConsumer() {
            return this.consumer;
        }

        public BiConsumer<T, RowContext> getContextConsumer() {
            return this.contextConsumer;
        }

        public Function<T, Boolean> getFunction() {
            return this.function;
        }

        public BiFunction<T, RowContext, Boolean> getContextFunction() {
            return this.contextFunction;
        }

        public Predicate<Row> getRowFilter() {
            return this.rowFilter;
        }

        public Predicate<T> getBeanFilter() {
            return this.beanFilter;
        }

        public BiFunction<Throwable, ReadContext, Boolean> getExceptionFunction() {
            return this.exceptionFunction;
        }

        public String getCharset() {
            return this.charset;
        }

        public Function<String, String> getTrim() {
            return this.trim;
        }

        public void setDataType(Class<T> dataType) {
            this.dataType = dataType;
        }

        public void setSheetNames(Set<String> sheetNames) {
            this.sheetNames = sheetNames;
        }

        public void setSheetIndexs(Set<Integer> sheetIndexs) {
            this.sheetIndexs = sheetIndexs;
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public void setContextConsumer(BiConsumer<T, RowContext> contextConsumer) {
            this.contextConsumer = contextConsumer;
        }

        public void setFunction(Function<T, Boolean> function) {
            this.function = function;
        }

        public void setContextFunction(BiFunction<T, RowContext, Boolean> contextFunction) {
            this.contextFunction = contextFunction;
        }

        public void setRowFilter(Predicate<Row> rowFilter) {
            this.rowFilter = rowFilter;
        }

        public void setBeanFilter(Predicate<T> beanFilter) {
            this.beanFilter = beanFilter;
        }

        public void setExceptionFunction(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
            this.exceptionFunction = exceptionFunction;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setTrim(Function<String, String> trim) {
            this.trim = trim;
        }

        public boolean isReadAllSheet() {
            return this.readAllSheet;
        }

        public void setReadAllSheet(boolean readAllSheet) {
            this.readAllSheet = readAllSheet;
        }

        public BiConsumer<String, Integer> getStartSheetConsumer() {
            return this.startSheetConsumer;
        }

        public void setStartSheetConsumer(BiConsumer<String, Integer> startSheetConsumer) {
            this.startSheetConsumer = startSheetConsumer;
        }
    }
}

