/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelFactory;
import com.github.liaochong.myexcel.core.parser.HtmlTableParser;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.strategy.SheetStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToExcelFactory
extends AbstractExcelFactory {
    private static final Logger log = LoggerFactory.getLogger(HtmlToExcelFactory.class);
    private HtmlTableParser htmlTableParser;

    public static HtmlToExcelFactory readHtml(File htmlFile) throws Exception {
        if (Objects.isNull(htmlFile) || !htmlFile.exists()) {
            throw new NoSuchFileException("html file is not exist");
        }
        HtmlToExcelFactory factory = new HtmlToExcelFactory();
        factory.htmlTableParser = HtmlTableParser.of(htmlFile);
        return factory;
    }

    public static HtmlToExcelFactory readHtml(String html) {
        HtmlToExcelFactory factory = new HtmlToExcelFactory();
        factory.htmlTableParser = HtmlTableParser.of(html);
        return factory;
    }

    public static HtmlToExcelFactory readHtml(File htmlFile, HtmlToExcelFactory htmlToExcelFactory) throws Exception {
        if (Objects.isNull(htmlFile) || !htmlFile.exists()) {
            throw new NoSuchFileException("Html file is not exist");
        }
        if (Objects.isNull(htmlToExcelFactory)) {
            throw new NullPointerException("HtmlToExcelFactory can not be null");
        }
        htmlToExcelFactory.htmlTableParser = HtmlTableParser.of(htmlFile);
        return htmlToExcelFactory;
    }

    public static HtmlToExcelFactory readHtml(String html, HtmlToExcelFactory htmlToExcelFactory) throws Exception {
        if (StringUtil.isBlank(html)) {
            throw new IllegalArgumentException("Html content is empty");
        }
        if (Objects.isNull(htmlToExcelFactory)) {
            throw new NullPointerException("HtmlToExcelFactory can not be null");
        }
        htmlToExcelFactory.htmlTableParser = HtmlTableParser.of(html);
        return htmlToExcelFactory;
    }

    @Override
    public Workbook build() {
        try {
            ParseConfig parseConfig = new ParseConfig(this.widthStrategy);
            List<Table> tables = this.htmlTableParser.getAllTable(parseConfig);
            this.htmlTableParser = null;
            return this.build(tables);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Workbook build(List<Table> tables, Workbook workbook) {
        if (Objects.nonNull(workbook)) {
            this.workbook = workbook;
        }
        return this.build(tables);
    }

    Workbook build(List<Table> tables) {
        if (Objects.isNull(tables) || tables.isEmpty()) {
            log.warn("There is no any table exist");
            return this.emptyWorkbook();
        }
        log.info("Start build excel");
        long startTime = System.currentTimeMillis();
        if (Objects.isNull(this.workbook)) {
            this.workbook = new XSSFWorkbook();
        }
        this.initCellStyle(this.workbook);
        if (SheetStrategy.isMultiSheet(this.sheetStrategy)) {
            this.buildTablesWithMultiSheet(tables);
        } else {
            this.buildTablesWithOneSheet(tables);
        }
        log.info("Build excel takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        return this.workbook;
    }

    private void buildTablesWithMultiSheet(List<Table> tables) {
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            boolean hasTd;
            Table table = tables.get(i);
            String sheetName = this.getRealSheetName(table.getCaption());
            Sheet sheet = this.workbook.getSheet(sheetName);
            if (sheet == null) {
                sheet = this.workbook.createSheet(sheetName);
            }
            if (!(hasTd = table.getTrList().stream().map(Tr::getTdList).anyMatch(list -> !list.isEmpty()))) continue;
            this.setTdOfTable(table, sheet);
            this.freezePane(i, sheet);
            tables.set(i, null);
        }
    }

    private void buildTablesWithOneSheet(List<Table> tables) {
        String sheetName = this.getRealSheetName(tables.get(0).getCaption());
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(sheetName);
        }
        for (int i = 0; i < tables.size(); ++i) {
            Table table = tables.get(i);
            boolean hasTd = table.getTrList().stream().map(Tr::getTdList).anyMatch(list -> !list.isEmpty());
            if (!hasTd) continue;
            this.setTdOfTable(table, sheet);
            this.freezePane(i, sheet);
            tables.set(i, null);
        }
    }

    private void setTdOfTable(Table table, Sheet sheet) {
        int maxColIndex = 0;
        if (WidthStrategy.isAutoWidth(this.widthStrategy) && !table.getTrList().isEmpty()) {
            maxColIndex = table.getTrList().parallelStream().mapToInt(tr -> tr.getTdList().stream().mapToInt(Td::getCol).max().orElse(0)).max().orElse(0);
        }
        Map<Integer, Integer> colMaxWidthMap = this.getColMaxWidthMap(table.getTrList());
        int sheetLastRowIndex = sheet.getLastRowNum();
        if (SheetStrategy.isOneSheet(this.sheetStrategy) && sheetLastRowIndex != 0) {
            ++sheetLastRowIndex;
        }
        int size = table.getTrList().size();
        for (int i = 0; i < size; ++i) {
            Tr tr2 = table.getTrList().get(i);
            this.updateTrIndex(tr2, sheetLastRowIndex);
            this.createRow(tr2, sheet);
            tr2.setTdList(null);
        }
        table.setTrList(null);
        this.setColWidth(colMaxWidthMap, sheet, maxColIndex);
    }

    private void updateTrIndex(Tr tr, int sheetLastRowIndex) {
        if (SheetStrategy.isOneSheet(this.sheetStrategy)) {
            tr.setIndex(tr.getIndex() + sheetLastRowIndex);
            tr.getTdList().forEach(td -> td.setRow(tr.getIndex()));
        }
    }
}

