/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.PromptContainer;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.Prompt;
import com.github.liaochong.myexcel.core.constant.FileType;
import com.github.liaochong.myexcel.core.constant.LinkType;
import com.github.liaochong.myexcel.utils.StringUtil;

public final class ExcelColumnMapping {
    private String title;
    private int order;
    private int index;
    private Class<?>[] groups;
    private String defaultValue;
    private int width;
    private boolean convertToString;
    private String format;
    private String[] style;
    private LinkType linkType;
    private String mapping;
    private FileType fileType;
    private boolean formula;
    private PromptContainer promptContainer;

    public static ExcelColumnMapping mapping(ExcelColumn excelColumn) {
        ExcelColumnMapping result = new ExcelColumnMapping();
        result.title = excelColumn.title();
        result.order = excelColumn.order();
        result.index = excelColumn.index();
        result.groups = excelColumn.groups();
        result.defaultValue = excelColumn.defaultValue();
        result.width = excelColumn.width();
        result.convertToString = excelColumn.convertToString();
        result.format = !excelColumn.format().isEmpty() ? excelColumn.format() : (!excelColumn.dateFormatPattern().isEmpty() ? excelColumn.dateFormatPattern() : (!excelColumn.decimalFormat().isEmpty() ? excelColumn.decimalFormat() : ""));
        result.style = excelColumn.style();
        result.linkType = excelColumn.linkType();
        result.mapping = excelColumn.mapping();
        result.fileType = excelColumn.fileType();
        result.formula = excelColumn.formula();
        Prompt prompt = excelColumn.prompt();
        if (StringUtil.isNotBlank(prompt.text())) {
            PromptContainer promptContainer = new PromptContainer();
            promptContainer.setTitle(prompt.title());
            promptContainer.setText(prompt.text());
            result.promptContainer = promptContainer;
        }
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public int getOrder() {
        return this.order;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?>[] getGroups() {
        return this.groups;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isConvertToString() {
        return this.convertToString;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getStyle() {
        return this.style;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public String getMapping() {
        return this.mapping;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isFormula() {
        return this.formula;
    }

    public PromptContainer getPromptContainer() {
        return this.promptContainer;
    }

    public void setPromptContainer(PromptContainer promptContainer) {
        this.promptContainer = promptContainer;
    }
}

