/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelFactory;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.SheetStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.core.templatehandler.TemplateHandler;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcelBuilder
implements ExcelBuilder {
    protected TemplateHandler templateHandler;
    protected HtmlToExcelFactory htmlToExcelFactory = new HtmlToExcelFactory();

    protected AbstractExcelBuilder(Class<? extends TemplateHandler> templateHandlerClass) {
        this.widthStrategy(WidthStrategy.COMPUTE_AUTO_WIDTH);
        this.sheetStrategy(SheetStrategy.MULTI_SHEET);
        this.templateHandler = ReflectUtil.newInstance(templateHandlerClass);
    }

    @Override
    public AbstractExcelBuilder workbookType(WorkbookType workbookType) {
        this.htmlToExcelFactory.workbookType(workbookType);
        return this;
    }

    @Override
    public AbstractExcelBuilder useDefaultStyle() {
        this.htmlToExcelFactory.useDefaultStyle();
        return this;
    }

    @Override
    public AbstractExcelBuilder widthStrategy(WidthStrategy widthStrategy) {
        this.htmlToExcelFactory.widthStrategy(widthStrategy);
        return this;
    }

    @Override
    @Deprecated
    public AbstractExcelBuilder autoWidthStrategy(AutoWidthStrategy autoWidthStrategy) {
        this.htmlToExcelFactory.widthStrategy(AutoWidthStrategy.map(autoWidthStrategy));
        return this;
    }

    @Override
    public AbstractExcelBuilder sheetStrategy(SheetStrategy sheetStrategy) {
        this.htmlToExcelFactory.sheetStrategy(sheetStrategy);
        return this;
    }

    @Override
    public AbstractExcelBuilder freezePanes(FreezePane ... freezePanes) {
        if (freezePanes == null || freezePanes.length == 0) {
            return this;
        }
        this.htmlToExcelFactory.freezePanes(freezePanes);
        return this;
    }

    @Override
    public <T> Workbook build(Map<String, T> data) {
        String template = this.templateHandler.render(data);
        try {
            return HtmlToExcelFactory.readHtml(template, this.htmlToExcelFactory).build();
        }
        catch (Exception e) {
            throw new ExcelBuildException("Build excel failure", e);
        }
    }

    @Override
    public ExcelBuilder classpathTemplate(String path) {
        this.templateHandler.classpathTemplate(path);
        return this;
    }

    @Override
    @Deprecated
    public ExcelBuilder template(String path) {
        return this.classpathTemplate(path);
    }

    @Override
    public ExcelBuilder fileTemplate(String dirPath, String fileName) {
        this.templateHandler.fileTemplate(dirPath, fileName);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelFactory != null) {
            this.htmlToExcelFactory.closeWorkbook();
        }
    }
}

