/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg.sync;

import com.github.kilianB.pcg.Pcg;
import com.github.kilianB.pcg.RandomBase64;

public abstract class RandomBaseSynchonized
extends RandomBase64 {
    private static final long serialVersionUID = -7066211507986864885L;
    protected long state;
    protected long inc;

    public RandomBaseSynchonized() {
    }

    public RandomBaseSynchonized(long seed, long streamNumber) {
        super(seed, streamNumber);
    }

    @Deprecated
    protected RandomBaseSynchonized(long initialState, long increment, boolean dummy) {
        super(initialState, increment, dummy);
    }

    @Override
    protected synchronized long stepRight() {
        long oldState = this.state;
        this.state = this.state * 6364136223846793005L + this.inc;
        return oldState;
    }

    @Override
    public synchronized void advance(long steps) {
        long acc_mult = 1L;
        long acc_plus = 0L;
        long cur_plus = this.inc;
        long cur_mult = 6364136223846793005L;
        while (Long.compareUnsigned(steps, 0L) > 0) {
            if ((steps & 1L) == 1L) {
                acc_mult *= cur_mult;
                acc_plus = acc_plus * cur_mult + cur_plus;
            }
            cur_plus *= cur_mult + 1L;
            cur_mult *= cur_mult;
            steps = Long.divideUnsigned(steps, 2L);
        }
        this.state = acc_mult * this.state + acc_plus;
    }

    @Override
    public synchronized <T> T split() throws ReflectiveOperationException {
        return super.split();
    }

    @Override
    public synchronized <T> T splitDistinct() throws ReflectiveOperationException {
        return super.splitDistinct();
    }

    @Override
    public synchronized long distanceUnsafe(Pcg other) {
        return super.distanceUnsafe(other);
    }

    @Override
    public synchronized long getState() {
        return this.state;
    }

    @Override
    public synchronized long getInc() {
        return this.inc;
    }

    @Override
    protected synchronized void setInc(long increment) {
        this.inc = increment;
    }

    @Override
    protected synchronized void setState(long initialState) {
        this.state = initialState;
    }

    @Override
    public boolean isFast() {
        return false;
    }
}

