/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg.cas;

import com.github.kilianB.pcg.Pcg;
import com.github.kilianB.pcg.RandomBase64;
import java.util.concurrent.atomic.AtomicLong;

public abstract class RandomBaseCAS
extends RandomBase64
implements Pcg {
    private static final long serialVersionUID = -4396858403047759432L;
    protected long mult64 = 6364136223846793005L;
    protected AtomicLong state;
    protected long inc;

    public RandomBaseCAS() {
    }

    public RandomBaseCAS(long seed, long streamNumber) {
        this.state = new AtomicLong(0L);
        this.inc = streamNumber << 1 | 1L;
        this.stepRight();
        this.state.addAndGet(seed);
        this.stepRight();
    }

    @Deprecated
    protected RandomBaseCAS(long initialState, long increment, boolean dummy) {
        if (increment == 0L) {
            throw new IllegalArgumentException("The increment can't be 0");
        }
        if (increment % 2L == 0L) {
            throw new IllegalArgumentException("Increment has to be odd");
        }
        this.setState(initialState);
        this.setInc(increment);
    }

    @Override
    protected long stepRight() {
        long newState;
        long oldState;
        AtomicLong state = this.state;
        while (!state.compareAndSet(oldState = state.get(), newState = oldState * this.mult64 + this.inc)) {
        }
        return oldState;
    }

    @Override
    public void advance(long steps) {
        long newState;
        long oldState;
        long acc_mult = 1L;
        long acc_plus = 0L;
        long cur_plus = this.inc;
        long cur_mult = this.mult64;
        while (Long.compareUnsigned(steps, 0L) > 0) {
            if ((steps & 1L) == 1L) {
                acc_mult *= cur_mult;
                acc_plus = acc_plus * cur_mult + cur_plus;
            }
            cur_plus *= cur_mult + 1L;
            cur_mult *= cur_mult;
            steps = Long.divideUnsigned(steps, 2L);
        }
        AtomicLong state = this.state;
        while (!state.compareAndSet(oldState = state.get(), newState = acc_mult * oldState + acc_plus)) {
        }
    }

    @Override
    protected abstract int getInt(long var1);

    @Override
    public boolean isFast() {
        return false;
    }

    @Override
    public long getState() {
        return this.state.get();
    }

    @Override
    public long getInc() {
        return this.inc;
    }

    @Override
    protected void setInc(long increment) {
        if (increment == 0L || increment % 2L == 0L) {
            throw new IllegalArgumentException("Increment may not be 0 or even. Value: " + increment);
        }
        this.inc = increment;
    }

    @Override
    protected void setState(long initialState) {
        if (this.state == null) {
            this.state = new AtomicLong(initialState);
        }
        this.state.set(initialState);
    }
}

