/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg;

import com.github.kilianB.pcg.IncompatibleGeneratorException;
import java.util.concurrent.atomic.AtomicLong;

public interface Pcg {
    public static final AtomicLong UNIQUE_SEED = new AtomicLong(System.nanoTime());

    public void advance(long var1);

    public <T> T split() throws ReflectiveOperationException;

    public <T> T splitDistinct() throws ReflectiveOperationException;

    public int next(int var1);

    public boolean nextBoolean();

    public boolean nextBoolean(double var1);

    public void nextBytes(byte[] var1);

    public char nextChar();

    public short nextShort();

    public byte nextByte();

    public int nextInt();

    public int nextInt(int var1);

    public long nextLong();

    public long nextLong(long var1);

    public float nextFloat();

    public float nextFloat(boolean var1, boolean var2);

    public double nextDouble();

    public double nextDouble(boolean var1, boolean var2);

    public double nextGaussian();

    default public long distance(Pcg other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new IncompatibleGeneratorException("Generator most likely should belong to the same class to be comparable.");
        }
        return this.distanceUnsafe(other);
    }

    default public long distanceUnsafe(Pcg other) {
        if (this.getInc() != other.getInc()) {
            throw new IncompatibleGeneratorException("Generators with distinct incremeants are not able to reach the same state");
        }
        long curState = this.getState();
        long newState = other.getState();
        long curPlus = this.getInc();
        long curMult = this.getMult();
        long bit = 1L;
        long distance = 0L;
        while (curState != newState) {
            if ((curState & bit) != (newState & bit)) {
                curState = curState * curMult + curPlus;
                distance |= bit;
            }
            bit <<= 1;
            curPlus = (curMult + 1L) * curPlus;
            curMult *= curMult;
        }
        if (this.isFast() != other.isFast()) {
            return distance - 1L;
        }
        return distance;
    }

    public boolean isFast();

    public long getState();

    public long getInc();

    public long getMult();
}

