/*
 * Decompiled with CFR 0.152.
 */
package lzma.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;
import org.cservenak.streams.Coder;

public class LzmaEncoderWrapper
implements Coder {
    private static final byte[] MINUS_ONE = new byte[8];
    private final Encoder encoder;

    public LzmaEncoderWrapper(Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public void code(InputStream in, OutputStream out) throws IOException {
        this.encoder.writeCoderProperties(out);
        out.write(MINUS_ONE);
        this.encoder.code(in, out, -1L, -1L, null);
    }

    static {
        for (int i = 0; i < MINUS_ONE.length; ++i) {
            LzmaEncoderWrapper.MINUS_ONE[i] = -1;
        }
    }

    public static class Builder {
        private int dictionnarySize = 0x800000;
        private boolean endMarkerMode = true;
        private int matchFinder = 1;
        private int numFastBytes = 32;

        public Builder useMaximalDictionarySize() {
            this.dictionnarySize = 0x10000000;
            return this;
        }

        public Builder useMediumDictionarySize() {
            this.dictionnarySize = 32768;
            return this;
        }

        public Builder useMinimalDictionarySize() {
            this.dictionnarySize = 1;
            return this;
        }

        public Builder useEndMarkerMode(boolean endMarkerMode) {
            this.endMarkerMode = endMarkerMode;
            return this;
        }

        public Builder useBT4MatchFinder() {
            this.matchFinder = 1;
            return this;
        }

        public Builder useBT2MatchFinder() {
            this.matchFinder = 0;
            return this;
        }

        public Builder useMinimalFastBytes() {
            this.numFastBytes = 5;
            return this;
        }

        public Builder useMediumFastBytes() {
            this.numFastBytes = 32;
            return this;
        }

        public Builder useMaximalFastBytes() {
            this.numFastBytes = 273;
            return this;
        }

        public LzmaEncoderWrapper build() {
            Encoder encoder = new Encoder();
            encoder.setDictionarySize(this.dictionnarySize);
            encoder.setEndMarkerMode(this.endMarkerMode);
            encoder.setMatchFinder(this.matchFinder);
            encoder.setNumFastBytes(this.numFastBytes);
            return new LzmaEncoderWrapper(encoder);
        }
    }
}

