/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffreyning.mybatisplus.base;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.github.jeffreyning.mybatisplus.anno.MppMultiId;
import com.github.jeffreyning.mybatisplus.util.CheckId;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByMultiIdMethod
extends AbstractMethod {
    private static final Logger logger = LoggerFactory.getLogger(DeleteByMultiIdMethod.class);

    public DeleteByMultiIdMethod() {
        super("deleteByMultiId");
    }

    private String getCol(List<TableFieldInfo> fieldList, String attrName) {
        for (TableFieldInfo tableFieldInfo : fieldList) {
            String prop = tableFieldInfo.getProperty();
            if (!prop.equals(attrName)) continue;
            return tableFieldInfo.getColumn();
        }
        throw new RuntimeException("not found column for " + attrName);
    }

    private String createWhere(Class<?> modelClass, TableInfo tableInfo) {
        List fieldList = tableInfo.getFieldList();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (TableFieldInfo fieldInfo : fieldList) {
            Field field = fieldInfo.getField();
            MppMultiId mppMultiId = field.getAnnotation(MppMultiId.class);
            if (mppMultiId == null) continue;
            String attrName2 = field.getName();
            String colName2 = this.getCol(fieldList, attrName2);
            idMap.put(attrName2, colName2);
        }
        CheckId.appendIdColum(modelClass, tableInfo, idMap);
        if (idMap.isEmpty()) {
            logger.info("entity {} not contain MppMultiId anno", (Object)modelClass.getName());
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        idMap.forEach((attrName, colName) -> {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append((String)colName).append("=").append("#{").append((String)attrName).append("}");
        });
        return sb.toString();
    }

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        String cWhere = this.createWhere(modelClass, tableInfo);
        if (cWhere == null) {
            return null;
        }
        String methodName = "deleteByMultiId";
        if (tableInfo.isLogicDelete()) {
            String sqlTemp = "<script>\nUPDATE %s %s WHERE " + cWhere + " %s\n</script>";
            String sql = String.format(sqlTemp, tableInfo.getTableName(), this.sqlLogicSet(tableInfo), tableInfo.getLogicDeleteSql(true, true));
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Object.class);
            return this.addUpdateMappedStatement(mapperClass, modelClass, methodName, sqlSource);
        }
        String sqlTemp = "DELETE FROM %s WHERE " + cWhere;
        String sql = String.format(sqlTemp, tableInfo.getTableName());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Object.class);
        return this.addDeleteMappedStatement(mapperClass, methodName, sqlSource);
    }
}

