/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.util;

import com.github.houbb.opencc4j.core.impl.ZhConvertBootstrap;
import com.github.houbb.opencc4j.support.segment.Segment;
import com.github.houbb.opencc4j.support.segment.impl.Segments;
import java.util.List;

public final class ZhConverterUtil {
    private ZhConverterUtil() {
    }

    public static boolean isSimple(String charOrPhrase) {
        return ZhConverterUtil.isSimple(charOrPhrase, Segments.defaults());
    }

    public static boolean isSimple(String charOrPhrase, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).isSimple(charOrPhrase);
    }

    public static boolean isTraditional(String charOrPhrase) {
        return ZhConverterUtil.isTraditional(charOrPhrase, Segments.defaults());
    }

    public static boolean isTraditional(String charOrPhrase, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).isTraditional(charOrPhrase);
    }

    public static List<String> simpleList(String original) {
        return ZhConverterUtil.simpleList(original, Segments.defaults());
    }

    public static List<String> simpleList(String original, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).simpleList(original);
    }

    public static List<String> traditionalList(String original) {
        return ZhConverterUtil.traditionalList(original, Segments.defaults());
    }

    public static List<String> traditionalList(String original, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).traditionalList(original);
    }

    public static String toSimple(String original) {
        return ZhConverterUtil.toSimple(original, Segments.defaults());
    }

    public static String toSimple(String original, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).toSimple(original);
    }

    public static String toTraditional(String original, Segment segment) {
        return ZhConvertBootstrap.newInstance().segment(segment).toTraditional(original);
    }

    public static String toTraditional(String original) {
        return ZhConverterUtil.toTraditional(original, Segments.defaults());
    }
}

