/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassGenericUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArrayUtil {
    public static final String[] STRING_EMPTY = new String[0];

    private ArrayUtil() {
    }

    public static boolean isEmpty(Object[] objects) {
        return null == objects || objects.length <= 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !ArrayUtil.isEmpty(objects);
    }

    public static <T> List<T> toList(T[] objects) {
        if (ArrayUtil.isEmpty(objects)) {
            return Collections.emptyList();
        }
        ArrayList<T> objectList = new ArrayList<T>(objects.length);
        objectList.addAll(Guavas.newArrayList(objects));
        return objectList;
    }

    public static Object[] toArray(List<?> objectList) {
        if (CollectionUtil.isEmpty(objectList)) {
            return new Object[0];
        }
        Object[] objects = new Object[objectList.size()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = objectList.get(i);
        }
        return objects;
    }

    public static <K, V> K[] toArray(V[] values, IHandler<? super V, K> keyFunction) {
        if (ArrayUtil.isEmpty(values)) {
            return new Object[0];
        }
        Object[] resultArray = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            K result = keyFunction.handle(values[i]);
            resultArray[i] = result;
        }
        return resultArray;
    }

    public static <K> K[] union(K[] values, K ... others) {
        if (ArrayUtil.isEmpty(values)) {
            return others;
        }
        if (ArrayUtil.isEmpty(others)) {
            return values;
        }
        Object[] resultArray = new Object[others.length];
        System.arraycopy(others, 0, resultArray, values.length, others.length);
        return resultArray;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean notContains(Object[] array, Object objectToFind) {
        return !ArrayUtil.contains(array, objectToFind);
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        block5: {
            block4: {
                if (array == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (objectToFind != null) break block4;
                for (int i = startIndex; i < array.length; ++i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block5;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block5;
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <R> R[] listToArray(List<R> list) {
        Class elemClass = ClassGenericUtil.getGenericClass(list);
        Object[] array = (Object[])Array.newInstance(elemClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    public static <E> List<E> arrayToList(E ... array) {
        if (ArrayUtil.isEmpty(array)) {
            return Guavas.newArrayList();
        }
        return Guavas.newArrayList(array);
    }

    public static int getStartIndex(int startIndex, Object[] arrays) {
        if (ArrayUtil.isEmpty(arrays)) {
            return 0;
        }
        if (startIndex < 0 || startIndex > arrays.length - 1) {
            return 0;
        }
        return startIndex;
    }

    public static int getEndIndex(int endIndex, Object[] arrays) {
        if (ArrayUtil.isEmpty(arrays)) {
            return 0;
        }
        int maxIndex = arrays.length - 1;
        if (endIndex < 0 || endIndex > maxIndex) {
            return maxIndex;
        }
        return endIndex;
    }

    public static Optional<Object> firstNotNullElem(Object[] objects) {
        if (ArrayUtil.isEmpty(objects)) {
            return Optional.empty();
        }
        for (Object elem : objects) {
            if (!ObjectUtil.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static Object[] newArray(Object ... objects) {
        return objects;
    }

    public static <K, V> List<K> toList(V[] values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyList();
        }
        List<K> list = Guavas.newArrayList(values.length);
        for (V value : values) {
            K key = keyFunction.handle(value);
            list.add(key);
        }
        return list;
    }

    public static List toList(Object arrayObject, IHandler keyFunction) {
        if (ObjectUtil.isNull(arrayObject)) {
            return Collections.emptyList();
        }
        Class<?> arrayClass = arrayObject.getClass();
        if (boolean[].class == arrayClass) {
            boolean[] booleans = (boolean[])arrayObject;
            return ArrayPrimitiveUtil.toList(booleans, keyFunction);
        }
        if (short[].class == arrayClass) {
            short[] shorts = (short[])arrayObject;
            return ArrayPrimitiveUtil.toList(shorts, keyFunction);
        }
        if (byte[].class == arrayClass) {
            byte[] bytes = (byte[])arrayObject;
            return ArrayPrimitiveUtil.toList(bytes, keyFunction);
        }
        if (int[].class == arrayClass) {
            int[] ints = (int[])arrayObject;
            return ArrayPrimitiveUtil.toList(ints, keyFunction);
        }
        if (float[].class == arrayClass) {
            float[] floats = (float[])arrayObject;
            return ArrayPrimitiveUtil.toList(floats, keyFunction);
        }
        if (double[].class == arrayClass) {
            double[] doubles = (double[])arrayObject;
            return ArrayPrimitiveUtil.toList(doubles, keyFunction);
        }
        if (char[].class == arrayClass) {
            char[] chars = (char[])arrayObject;
            return ArrayPrimitiveUtil.toList(chars, keyFunction);
        }
        if (long[].class == arrayClass) {
            long[] longs = (long[])arrayObject;
            return ArrayPrimitiveUtil.toList(longs, keyFunction);
        }
        Object[] objects = (Object[])arrayObject;
        return ArrayUtil.toList(objects, keyFunction);
    }

    public static Object[] shift(Object[] array, int offset) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int arrayLength = array.length;
        int actualOffset = offset;
        if (actualOffset < 0) {
            actualOffset += arrayLength;
        }
        Object[] newArray = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            int realIndex = (i + actualOffset) % arrayLength;
            newArray[i] = array[realIndex];
        }
        return newArray;
    }

    public static int lastIndexOf(char[] chars, char c, int startIndex, int endIndex) {
        if (chars == null || chars.length == 0) {
            return -1;
        }
        for (int i = endIndex; i >= startIndex; --i) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] chars, char c) {
        if (ArrayPrimitiveUtil.isEmpty(chars)) {
            return -1;
        }
        return ArrayUtil.lastIndexOf(chars, c, 0, chars.length - 1);
    }
}

