/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io.ext.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.ext.IFiles;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

@ThreadSafe
public class RandomAccessFiles
implements IFiles {
    private final RandomAccessFile file;

    public RandomAccessFiles(String path) {
        try {
            this.file = new RandomAccessFile(path, "rw");
        }
        catch (FileNotFoundException e) {
            throw new CommonRuntimeException(e);
        }
    }

    @Override
    public byte[] read(long startIndex, long endIndex) {
        try {
            ArgUtil.notNegative(startIndex, "startIndex not allow negative!");
            ArgUtil.assertTrue(endIndex >= startIndex, "endIndex >= startIndex is expected!");
            long actualEndIndex = this.getMin(this.file.length(), endIndex);
            int length = (int)(actualEndIndex - startIndex);
            int startIndexInt = (int)startIndex;
            byte[] bytes = new byte[length];
            this.file.readFully(bytes, startIndexInt, length);
            return bytes;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    @Override
    public String read(long startIndex, long endIndex, String charset) {
        try {
            byte[] bytes = this.read(startIndex, endIndex);
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new CommonRuntimeException(e);
        }
    }

    @Override
    public void write(long startIndex, byte[] bytes) {
        ArgUtil.notNegative(startIndex, "startIndex not allow negative!");
        try {
            long fileLength = this.file.length();
            long actualStartIndex = this.getMin(startIndex, fileLength);
            byte[] tempBytes = this.read(actualStartIndex, fileLength);
            this.file.seek(actualStartIndex);
            this.file.write(bytes);
            this.file.write(tempBytes);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    private long getMin(long paramOne, long paramTwo) {
        if (paramOne <= paramTwo) {
            return paramOne;
        }
        return paramTwo;
    }
}

