/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.FileUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static List<String> getIndexList(String compressJsonPath, int size) {
        String json = FileUtil.getFileContent(compressJsonPath);
        if (StringUtil.isEmptyTrim(json) || size <= 0) {
            return Collections.emptyList();
        }
        List<Integer> prefixList = CollectionUtil.fill(size);
        return JsonUtil.getIndexList(compressJsonPath, prefixList);
    }

    public static List<String> getIndexList(String compressJsonPath, List<?> indexPrefixList) {
        int i;
        String json = FileUtil.getFileContent(compressJsonPath);
        if (StringUtil.isEmptyTrim(json) || CollectionUtil.isEmpty(indexPrefixList)) {
            return Collections.emptyList();
        }
        List<String> results = Guavas.newArrayList(indexPrefixList.size());
        Stack<Integer> stack = new Stack<Integer>();
        List<String> indexList = Guavas.newArrayList(indexPrefixList.size());
        for (i = 0; i < json.length(); ++i) {
            char ch = json.charAt(i);
            if ('{' == ch) {
                stack.push(i);
            }
            if ('}' != ch) continue;
            Integer startIndex = (Integer)stack.pop();
            int endIndex = i + 1;
            int byteStartIndex = json.substring(0, startIndex).getBytes().length;
            int byteEndIndex = byteStartIndex + json.substring(startIndex, endIndex).getBytes().length;
            String result = byteStartIndex + "," + byteEndIndex;
            indexList.add(result);
        }
        for (i = 0; i < indexPrefixList.size(); ++i) {
            String prefix = JsonUtil.getPrefix(indexPrefixList.get(i));
            String result = prefix + (String)indexList.get(i);
            results.add(result);
        }
        return results;
    }

    private static String getPrefix(Object object) {
        if (ObjectUtil.isNull(object)) {
            return "";
        }
        String string = object.toString();
        if (StringUtil.isEmptyTrim(string)) {
            return "";
        }
        return string + " ";
    }
}

