/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerBankLuhnHelper;
import com.github.houbb.chars.scan.util.InnerBufferUtil;
import com.github.houbb.chars.scan.util.InnerIdNoHelper;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.CharUtil;
import java.util.Arrays;
import java.util.Collection;

public class MergeNumsConditionCharScan
extends AbstractConditionCharScan {
    private final Collection<String> scanTypeCollect;

    public MergeNumsConditionCharScan() {
        this(Arrays.asList(CharsScanTypeEnum.PHONE.getScanType(), CharsScanTypeEnum.BANK_CARD.getScanType(), CharsScanTypeEnum.ID_NO.getScanType()));
    }

    public MergeNumsConditionCharScan(Collection<String> scanTypeEnums) {
        ArgUtil.notNull(scanTypeEnums, (String)"scanTypeEnums");
        this.scanTypeCollect = scanTypeEnums;
    }

    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c);
    }

    @Override
    protected void addItemWhenStringMatch(int i, char c, char[] chars, CharsScanContext context) {
        StringBuilder buffer = super.getBuffer();
        int bufLen = buffer.length();
        if (bufLen == 11) {
            boolean isPhone;
            boolean bl = isPhone = this.scanTypeCollect.contains(CharsScanTypeEnum.PHONE.getScanType()) && InnerBufferUtil.isPhone(buffer);
            if (isPhone) {
                this.addMatchItemForMerge(CharsScanTypeEnum.PHONE, i, chars, context);
            }
        } else if (bufLen == 15 || bufLen == 16 || bufLen == 19) {
            boolean isBankNo;
            boolean bl = isBankNo = this.scanTypeCollect.contains(CharsScanTypeEnum.BANK_CARD.getScanType()) && InnerBankLuhnHelper.isValidBankNo(buffer);
            if (isBankNo) {
                super.addMatchItemForMerge(CharsScanTypeEnum.BANK_CARD, i, chars, context);
            }
        } else if (bufLen == 18) {
            boolean isIdNoFlag;
            boolean bl = isIdNoFlag = this.scanTypeCollect.contains(CharsScanTypeEnum.ID_NO.getScanType()) && InnerIdNoHelper.isValidIdNo(buffer);
            if (isIdNoFlag) {
                super.addMatchItemForMerge(CharsScanTypeEnum.ID_NO, i, chars, context);
            }
        } else if (bufLen == 17) {
            boolean isBankNo;
            char nextChar;
            int nextCharIx = i + 1;
            if (nextCharIx < chars.length && ((nextChar = chars[nextCharIx]) == 'x' || nextChar == 'X')) {
                boolean isIdNoFlag;
                buffer.append(nextChar);
                boolean bl = isIdNoFlag = this.scanTypeCollect.contains(CharsScanTypeEnum.ID_NO.getScanType()) && InnerIdNoHelper.isValidIdNo(buffer);
                if (isIdNoFlag) {
                    super.addMatchItemForMerge(CharsScanTypeEnum.ID_NO, i, chars, context);
                    return;
                }
            }
            boolean bl = isBankNo = this.scanTypeCollect.contains(CharsScanTypeEnum.BANK_CARD.getScanType()) && InnerBankLuhnHelper.isValidBankNo(buffer);
            if (isBankNo) {
                super.addMatchItemForMerge(CharsScanTypeEnum.BANK_CARD, i, chars, context);
            }
        }
    }

    @Override
    protected boolean isSupportMergeScanType(CharsScanTypeEnum scanTypeEnum, int i, char[] chars, CharsScanContext context) {
        return this.scanTypeCollect.contains(scanTypeEnum.getScanType());
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.MERGE_NUMS.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.MERGE_NUMS.getPriority();
    }
}

