/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractCharScan;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.trie.api.ITrieTree;
import java.util.Set;

public abstract class AbstractConditionCharScan
extends AbstractCharScan {
    protected abstract boolean isCharMatchCondition(int var1, char var2, char[] var3);

    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        return true;
    }

    @Override
    public void scan(int i, char c, char[] chars, CharsScanContext context) {
        boolean currentMatchCondition = this.isCharMatchCondition(i, c, chars);
        if (!this.isPreCharMatchCondition() && currentMatchCondition) {
            this.clearBuffer();
            this.getBuffer().append(c);
        } else if (this.isPreCharMatchCondition() || currentMatchCondition) {
            if (this.isPreCharMatchCondition() && currentMatchCondition) {
                this.getBuffer().append(c);
            } else if (this.isPreCharMatchCondition() && !currentMatchCondition) {
                this.clearBufferAndAddItem(i, c, chars, context);
            }
        }
        this.setPreCharMatchCondition(currentMatchCondition);
        if (i == chars.length - 1 && currentMatchCondition) {
            this.clearBufferAndAddItem(i + 1, c, chars, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBufferAndAddItem(int i, char c, char[] chars, CharsScanContext context) {
        try {
            boolean prefixFlag = this.isPrefixMatch(i, c, chars, context);
            if (!prefixFlag) {
                return;
            }
            ITrieTree trieTree = context.whiteListTrie();
            if (trieTree.search(this.getBuffer())) {
                return;
            }
            this.addItemWhenStringMatch(i, c, chars, context);
        }
        finally {
            this.clearBuffer();
        }
    }

    protected void addItemWhenStringMatch(int i, char c, char[] chars, CharsScanContext context) {
        boolean isStringMatchCondition = this.isStringMatchCondition(i, c, chars, context);
        if (isStringMatchCondition) {
            CharsScanMatchItem charsScanMatchItem = new CharsScanMatchItem();
            int bufferLen = this.getBuffer().length();
            String scanType = this.getScanType();
            charsScanMatchItem.setStartIndex(i - bufferLen);
            charsScanMatchItem.setEndIndex(i - 1);
            charsScanMatchItem.setScanType(scanType);
            charsScanMatchItem.setPriority(this.getPriority());
            super.addMatchItem(charsScanMatchItem);
        }
    }

    protected boolean isPrefixMatch(int i, char c, char[] chars, CharsScanContext context) {
        Set<Character> characterSet = context.prefixCharSet();
        if (CollectionUtil.isEmpty(characterSet)) {
            return true;
        }
        int prefixIx = this.getPrefixMatchPrefixIx(i, chars, context);
        if (prefixIx < 0) {
            return false;
        }
        char preChar = chars[prefixIx];
        if (this.isAnyChineseMatch(preChar, context)) {
            return true;
        }
        return this.isPrefixCharContains(characterSet, preChar);
    }

    protected int getPrefixMatchPrefixIx(int i, char[] chars, CharsScanContext context) {
        StringBuilder buffer = this.getBuffer();
        int bufferLen = buffer.length();
        int prefixIx = i - bufferLen - 1;
        return prefixIx;
    }

    protected boolean isAnyChineseMatch(char preChar, CharsScanContext context) {
        String scanType = this.getScanType();
        if (CharsScanTypeEnum.PHONE.getScanType().equals(scanType) || CharsScanTypeEnum.EMAIL.getScanType().equals(scanType) || CharsScanTypeEnum.BANK_CARD.getScanType().equals(scanType) || CharsScanTypeEnum.ID_NO.getScanType().equals(scanType) || CharsScanTypeEnum.MERGE_NUMS.getScanType().equals(scanType)) {
            return CharUtil.isChinese((char)preChar);
        }
        return false;
    }

    protected boolean isPrefixCharContains(Set<Character> characterSet, char preChar) {
        return characterSet.contains(Character.valueOf(preChar));
    }

    protected void addMatchItemForMerge(CharsScanTypeEnum scanTypeEnum, int i, char[] chars, CharsScanContext context) {
        boolean isSupport = this.isSupportMergeScanType(scanTypeEnum, i, chars, context);
        if (!isSupport) {
            return;
        }
        CharsScanMatchItem charsScanMatchItem = new CharsScanMatchItem();
        int bufferLen = this.getBuffer().length();
        charsScanMatchItem.setStartIndex(i - bufferLen);
        charsScanMatchItem.setEndIndex(i - 1);
        charsScanMatchItem.setScanType(scanTypeEnum.getScanType());
        charsScanMatchItem.setPriority(scanTypeEnum.getPriority());
        super.addMatchItem(charsScanMatchItem);
    }

    protected boolean isSupportMergeScanType(CharsScanTypeEnum scanTypeEnum, int i, char[] chars, CharsScanContext context) {
        return true;
    }
}

