/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.replace;

import com.github.houbb.chars.scan.api.ICharsReplace;
import com.github.houbb.chars.scan.api.ICharsReplaceFactory;
import com.github.houbb.chars.scan.exception.CharsScanException;
import com.github.houbb.chars.scan.support.replace.SingletonCharsReplaceFactory;
import com.github.houbb.chars.scan.support.replace.factory.CharsReplaceFactory;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharsReplaces {
    private static final Map<String, ICharsReplace> DEFAULT_MAP = CharsReplaces.chainsMap(SingletonCharsReplaceFactory.getBankCard(), SingletonCharsReplaceFactory.getChineseName(), SingletonCharsReplaceFactory.getBirthday(), SingletonCharsReplaceFactory.getChineseName(), SingletonCharsReplaceFactory.getEmail(), SingletonCharsReplaceFactory.getGps(), SingletonCharsReplaceFactory.getIdNo(), SingletonCharsReplaceFactory.getPhone(), SingletonCharsReplaceFactory.getIpv4(), SingletonCharsReplaceFactory.getAddress(), SingletonCharsReplaceFactory.getPassport(), SingletonCharsReplaceFactory.getMaskHalf(), SingletonCharsReplaceFactory.getMaskAll(), SingletonCharsReplaceFactory.getNone());

    public static ICharsReplaceFactory defaults() {
        return new CharsReplaceFactory();
    }

    private static List<ICharsReplace> chains(ICharsReplace ... replaces) {
        if (ArrayUtil.isEmpty((Object[])replaces)) {
            return Collections.emptyList();
        }
        ArrayList<ICharsReplace> list = new ArrayList<ICharsReplace>(Arrays.asList(replaces));
        return list;
    }

    public static Map<String, ICharsReplace> chainsMap(ICharsReplace ... replaces) {
        HashMap<String, ICharsReplace> map = new HashMap<String, ICharsReplace>();
        if (ArrayUtil.isEmpty((Object[])replaces)) {
            return map;
        }
        for (ICharsReplace replace : replaces) {
            map.put(replace.getScanType(), replace);
        }
        return map;
    }

    public static Map<String, ICharsReplace> chainsMap(Collection<ICharsReplace> charsReplaceCollection) {
        HashMap<String, ICharsReplace> map = new HashMap<String, ICharsReplace>();
        if (CollectionUtil.isEmpty(charsReplaceCollection)) {
            return map;
        }
        for (ICharsReplace replace : charsReplaceCollection) {
            map.put(replace.getScanType(), replace);
        }
        return map;
    }

    public static Collection<ICharsReplace> defaultReplaceCollection() {
        return Collections.unmodifiableCollection(DEFAULT_MAP.values());
    }

    public static ICharsReplace defaultReplace() {
        return SingletonCharsReplaceFactory.getMaskHalf();
    }

    private static ICharsReplace getCharsReplace(String scanTypeCode) {
        ICharsReplace charsReplace = DEFAULT_MAP.get(scanTypeCode);
        if (charsReplace == null) {
            throw new CharsScanException("Not support replace for " + scanTypeCode);
        }
        return charsReplace;
    }

    public static ICharsReplaceFactory defaultsReplaceFactory(List<String> scanTypeList, String defaultScanType) {
        ArrayList<ICharsReplace> replaceList = new ArrayList<ICharsReplace>(scanTypeList.size());
        for (String scanType : scanTypeList) {
            replaceList.add(CharsReplaces.getCharsReplace(scanType));
        }
        ICharsReplace defaultReplace = CharsReplaces.getCharsReplace(defaultScanType);
        return new CharsReplaceFactory(replaceList, defaultReplace);
    }
}

