/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.core;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.api.ICharsReplace;
import com.github.houbb.chars.scan.api.ICharsReplaceFactory;
import com.github.houbb.chars.scan.api.ICharsScan;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.chars.scan.support.core.AbstractCharsCore;
import com.github.houbb.chars.scan.support.scan.compare.CharsScanItemComparator;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CharsCoreCommon
extends AbstractCharsCore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CharsScanMatchItem> scan(String originalText, CharsScanContext context, char[] chars) {
        try {
            List<ICharsScan> charsScanList = this.getCharScanList(context);
            List<CharsScanMatchItem> list = this.doScan(chars, charsScanList, context);
            return list;
        }
        finally {
            this.finallyCallBack(context);
        }
    }

    protected List<ICharsScan> getCharScanList(CharsScanContext context) {
        ICharsScanFactory charScanFactory = context.getCharScanFactory();
        return charScanFactory.allCharScanList();
    }

    protected void finallyCallBack(CharsScanContext context) {
    }

    protected List<CharsScanMatchItem> doScan(char[] chars, List<ICharsScan> charsScanList, CharsScanContext context) {
        int scanStartIndex;
        int charsScanSize = charsScanList.size();
        for (int i = scanStartIndex = context.scanStartIndex(); i < chars.length; ++i) {
            char currentChar = chars[i];
            for (int j = 0; j < charsScanSize; ++j) {
                ICharsScan charsScan = charsScanList.get(j);
                charsScan.scan(i, currentChar, chars, context);
            }
        }
        ArrayList<CharsScanMatchItem> resultList = new ArrayList<CharsScanMatchItem>();
        for (int j = 0; j < charsScanSize; ++j) {
            ICharsScan charsScan = charsScanList.get(j);
            List<CharsScanMatchItem> itemList = charsScan.getMatchList();
            if (!CollectionUtil.isNotEmpty(itemList)) continue;
            resultList.addAll(itemList);
        }
        return resultList;
    }

    @Override
    public String replace(List<CharsScanMatchItem> charsScanMatchItemList, String originalString, CharsScanContext context, char[] oldChars) {
        ICharsReplaceFactory charsReplaceFactory = context.getCharsReplaceFactory();
        StringBuilder stringBuilder = new StringBuilder();
        if (charsScanMatchItemList.size() > 1) {
            Collections.sort(charsScanMatchItemList, new CharsScanItemComparator());
        }
        int itemListIx = 0;
        int startIx = 0;
        int endIx = 0;
        while (endIx < oldChars.length && itemListIx < charsScanMatchItemList.size()) {
            boolean hasReplaced;
            CharsScanMatchItem charsScanMatchItem = charsScanMatchItemList.get(itemListIx);
            int currentItemEndIndex = charsScanMatchItem.getEndIndex();
            if (currentItemEndIndex <= endIx) {
                ++itemListIx;
                continue;
            }
            if ((endIx = Math.max(endIx, CharsCoreCommon.getEndIndex(charsScanMatchItem))) > startIx) {
                InnerCharUtil.appendChars(stringBuilder, oldChars, startIx, endIx - 1);
            }
            if (hasReplaced = CharsCoreCommon.hasReplaced(startIx, endIx, charsScanMatchItemList, itemListIx)) {
                InnerCharUtil.appendChars(stringBuilder, oldChars, charsScanMatchItem.getStartIndex(), charsScanMatchItem.getEndIndex());
            } else {
                ICharsReplace charsReplace = charsReplaceFactory.getReplace(charsScanMatchItem.getScanType());
                charsReplace.replace(stringBuilder, oldChars, charsScanMatchItem, context);
            }
            startIx = Math.max(endIx, charsScanMatchItem.getEndIndex()) + 1;
            endIx = Math.max(startIx, endIx);
            ++itemListIx;
        }
        if (startIx < oldChars.length) {
            InnerCharUtil.appendChars(stringBuilder, oldChars, startIx, oldChars.length - 1);
        }
        return stringBuilder.toString();
    }

    private static boolean hasReplaced(int startIx, int endIx, List<CharsScanMatchItem> charsScanMatchItemList, int itemIndex) {
        CharsScanMatchItem item = charsScanMatchItemList.get(itemIndex);
        return endIx > item.getEndIndex();
    }

    private static int getEndIndex(CharsScanMatchItem charsScanMatchItem) {
        return charsScanMatchItem.getStartIndex();
    }
}

