/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.Util;
import com.google.gson.Gson;
import com.yunkuent.sdk.EntEngine;
import com.yunkuent.sdk.FilePermissions;
import com.yunkuent.sdk.HostConfig;
import com.yunkuent.sdk.ScopeType;
import com.yunkuent.sdk.UploadManager;
import com.yunkuent.sdk.data.FileInfo;
import com.yunkuent.sdk.data.YunkuException;
import com.yunkuent.sdk.upload.IEntFileManager;
import com.yunkuent.sdk.upload.UploadCallback;
import com.yunkuent.sdk.utils.YKUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class EntFileManager
extends EntEngine
implements IEntFileManager {
    private static final String TAG = "EntFileManager";
    protected static String DEFAULT_OPNAME = "";
    protected static int DEFAULT_BLOCKSIZE = 0xA00000;
    protected static String UPLOAD_ROOT_PATH = "";
    private final String URL_API_FILELIST = HostConfig.API_ENT_HOST + "/1/file/ls";
    private final String URL_API_UPDATE_LIST = HostConfig.API_ENT_HOST + "/1/file/updates";
    private final String URL_API_FILE_INFO = HostConfig.API_ENT_HOST + "/1/file/info";
    private final String URL_API_CREATE_FOLDER = HostConfig.API_ENT_HOST + "/1/file/create_folder";
    private final String URL_API_CREATE_FILE = HostConfig.API_ENT_HOST + "/1/file/create_file";
    private final String URL_API_COPY_FILE = HostConfig.API_ENT_HOST + "/1/file/copy";
    private final String URL_API_MCOPY_FILE = HostConfig.API_ENT_HOST + "/1/file/mcopy";
    private final String URL_API_DEL_FILE = HostConfig.API_ENT_HOST + "/1/file/del";
    private final String URL_API_RECYCLE_FILE = HostConfig.API_ENT_HOST + "/1/file/recycle";
    private final String URL_API_RECOVER_FILE = HostConfig.API_ENT_HOST + "/1/file/recover";
    private final String URL_API_DEL_COMPLETELY_FILE = HostConfig.API_ENT_HOST + "/1/file/del_completely";
    private final String URL_API_MOVE_FILE = HostConfig.API_ENT_HOST + "/1/file/move";
    private final String URL_API_HISTORY_FILE = HostConfig.API_ENT_HOST + "/1/file/history";
    private final String URL_API_LINK_FILE = HostConfig.API_ENT_HOST + "/1/file/link";
    private final String URL_API_LINK_CLOSE = HostConfig.API_ENT_HOST + "/1/file/link_close";
    private final String URL_API_GET_LINK = HostConfig.API_ENT_HOST + "/1/file/links";
    private final String URL_API_UPDATE_COUNT = HostConfig.API_ENT_HOST + "/1/file/updates_count";
    private final String URL_API_GET_SERVER_SITE = HostConfig.API_ENT_HOST + "/1/file/servers";
    private final String URL_API_UPLOAD_SERVERS = HostConfig.API_ENT_HOST + "/1/file/upload_servers";
    private final String URL_API_GET_UPLOAD_URL = HostConfig.API_ENT_HOST + "/1/file/download_url";
    private final String URL_API_FILE_SEARCH = HostConfig.API_ENT_HOST + "/1/file/search";
    private final String URL_API_PREVIEW_URL = HostConfig.API_ENT_HOST + "/1/file/preview_url";
    private final String URL_API_GET_PERMISSION = HostConfig.API_ENT_HOST + "/1/file/get_permission";
    private final String URL_API_SET_PERMISSION = HostConfig.API_ENT_HOST + "/1/file/file_permission";
    private final String URL_API_ADD_TAG = HostConfig.API_ENT_HOST + "/1/file/add_tag";
    private final String URL_API_DEL_TAG = HostConfig.API_ENT_HOST + "/1/file/del_tag";
    private final String URL_API_STAT = HostConfig.API_ENT_HOST + "/1/file/stat";
    private final String URL_API_CEDIT_URL = HostConfig.API_ENT_HOST + "/1/file/cedit_url";
    private final String URL_API_SET_PERMISSION_INHERIT = HostConfig.API_ENT_HOST + "/1/file/set_permission_inherit";
    private final String URL_API_GET_ALL_PERMISSION = HostConfig.API_ENT_HOST + "/1/file/get_all_permission";
    private final String URL_API_RESET_PERMISSION = HostConfig.API_ENT_HOST + "/1/file/reset_permission";
    private final String URL_API_SET_METADATA = HostConfig.API_ENT_HOST + "/1/file/set_metadata";
    private final String URL_API_DEL_METADATA = HostConfig.API_ENT_HOST + "/1/file/del_metadata";
    private final String URL_API_QUEUE_STATUS = HostConfig.API_ENT_HOST + "/1/file/queue_status";

    public EntFileManager(String orgClientId, String secret) {
        super(orgClientId, secret);
        this.clientIdKey = "org_client_id";
    }

    private void setOp(HashMap<String, String> params, String opName, int opId) {
        if (opId > 0) {
            params.put("op_id", Integer.toString(opId));
        } else if (!Util.isEmpty((CharSequence)opName)) {
            params.put("op_name", opName);
        }
    }

    public ReturnResult getFileList(int start, int size) {
        return this.getFileList("", null, start, size, false, null);
    }

    public ReturnResult getFileList(String fullpath, int start, int size) {
        return this.getFileList(fullpath, null, start, size, false, null);
    }

    public ReturnResult getFileList(String fullpath, String order, int start, int size) {
        return this.getFileList(fullpath, order, start, size, false, null);
    }

    public ReturnResult getFileList(String fullpath, String order, int start, int size, boolean dirOnly, String tag) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("tag", tag);
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        params.put("order", order);
        if (dirOnly) {
            params.put("dir", "1");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_FILELIST).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getUpdateList(boolean isCompare, long fetchDateline, String dir) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isCompare) {
            params.put("mode", "compare");
        }
        if (!YKUtils.isEmpty((CharSequence)dir)) {
            params.put("dir", dir);
        }
        params.put("fetch_dateline", Long.toString(fetchDateline));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_UPDATE_LIST).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getFileInfo(String hash, String fullpath, NetType net, boolean getAttribute) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        params.put("attribute", getAttribute ? "1" : "0");
        switch (net) {
            case DEFAULT: {
                break;
            }
            case IN: {
                params.put("net", net.name().toLowerCase());
            }
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_FILE_INFO).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getFileInfo(String hash, String fullpath) {
        return this.getFileInfo(hash, fullpath, NetType.DEFAULT, false);
    }

    public ReturnResult createFolder(String fullpath, String opName, int opId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_CREATE_FOLDER).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult createFolder(String fullpath, String opName) {
        return this.createFolder(fullpath, opName, 0);
    }

    @Override
    public ReturnResult createFile(String fullpath, String fileHash, long fileSize, boolean overwrite, String opName, int opId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("filehash", fileHash);
        params.put("filesize", Long.toString(fileSize));
        params.put("overwrite", overwrite ? "1" : "0");
        params.put("storage_check", "0");
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_CREATE_FILE).setMethod(RequestMethod.POST).executeSync();
    }

    private String getRealPath(String fullpath) {
        if (Util.isEmpty((CharSequence)UPLOAD_ROOT_PATH)) {
            return fullpath;
        }
        return UPLOAD_ROOT_PATH + fullpath;
    }

    private UploadManager initUploadManager(String opName, int opId, int blockSize) {
        opName = Util.isEmpty((CharSequence)opName) ? DEFAULT_OPNAME : opName;
        UploadManager manager = new UploadManager(blockSize, this);
        if (opId > 0) {
            manager.setOperator(opId);
        }
        if (!Util.isEmpty((CharSequence)opName)) {
            manager.setOperator(opName);
        }
        return manager;
    }

    public FileInfo uploadByBlock(String fullpath, String opName, int opId, String localFile, boolean overwrite, int blockSize) throws YunkuException {
        UploadManager manager = this.initUploadManager(opName, opId, blockSize);
        fullpath = this.getRealPath(fullpath);
        return manager.upload(localFile, fullpath, overwrite);
    }

    public FileInfo uploadByBlock(String fullpath, String opName, int opId, String localFile, boolean overwrite) throws YunkuException {
        return this.uploadByBlock(fullpath, opName, opId, localFile, overwrite, DEFAULT_BLOCKSIZE);
    }

    public FileInfo uploadByBlock(String fullpath, String opName, int opId, InputStream stream, boolean overwrite, int blockSize) throws YunkuException {
        UploadManager manager = this.initUploadManager(opName, opId, blockSize);
        fullpath = this.getRealPath(fullpath);
        return manager.upload(stream, fullpath, overwrite);
    }

    public FileInfo uploadByBlock(String fullpath, String opName, int opId, InputStream stream, boolean overwrite) throws YunkuException {
        return this.uploadByBlock(fullpath, opName, opId, stream, overwrite, DEFAULT_BLOCKSIZE);
    }

    public UploadManager uploadByBlockAsync(String fullpath, String opName, int opId, String localFile, boolean overwrite, UploadCallback callback) {
        return this.uploadByBlockAsync(fullpath, opName, opId, localFile, overwrite, DEFAULT_BLOCKSIZE, callback);
    }

    public UploadManager uploadByBlockAsync(String fullpath, String opName, int opId, String localFile, boolean overwrite, int blockSize, UploadCallback callback) {
        UploadManager manager = this.initUploadManager(opName, opId, blockSize);
        fullpath = this.getRealPath(fullpath);
        manager.uploadAsync(localFile, fullpath, overwrite, callback);
        return manager;
    }

    public UploadManager uploadByBlockAsync(String fullpath, String opName, int opId, InputStream stream, boolean overwrite, UploadCallback callback) {
        return this.uploadByBlockAsync(fullpath, opName, opId, stream, overwrite, DEFAULT_BLOCKSIZE, callback);
    }

    public UploadManager uploadByBlockAsync(String fullpath, String opName, int opId, InputStream stream, boolean overwrite, int blockSize, UploadCallback callback) {
        UploadManager manager = this.initUploadManager(opName, opId, blockSize);
        fullpath = this.getRealPath(fullpath);
        manager.uploadAsync(stream, fullpath, overwrite, callback);
        return manager;
    }

    public ReturnResult copy(String originFullpath, String targetFullpath, String opName, int opId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("from_fullpath", originFullpath);
        params.put("fullpath", targetFullpath);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_COPY_FILE).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult copy(String originFullpath, String targetFullpath, String opName) {
        return this.copy(originFullpath, targetFullpath, opName, 0);
    }

    public ReturnResult copyAll(String[] originFullpaths, String[] targetPaths, String sp, String opName, int opId, String copyAll) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("from_fullpaths", Util.strArrayToString((String[])originFullpaths, (String)"|"));
        params.put("paths", Util.strArrayToString((String[])targetPaths, (String)"|"));
        params.put("sp", sp);
        params.put("copy_all", copyAll);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_MCOPY_FILE).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult copyAll(String[] originFullpaths, String[] targetPaths, String opName) {
        return this.copyAll(originFullpaths, targetPaths, null, opName, 0, "1");
    }

    public ReturnResult del(String[] fullpaths, boolean destroy, String opName, int opId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpaths", Util.strArrayToString((String[])fullpaths, (String)"|"));
        params.put("destroy", destroy ? "1" : "0");
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(this.URL_API_DEL_FILE).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult del(String[] fullpaths, boolean destroy, String opName) {
        return this.del(fullpaths, destroy, opName, 0);
    }

    public ReturnResult delByTag(String tag, String path, boolean destroy, String opName, int opId) {
        String url = this.URL_API_DEL_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tag", tag);
        params.put("destroy", destroy ? "1" : "0");
        params.put("path", path);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delByTag(String tag, String path, boolean destroy, String opName) {
        return this.delByTag(tag, path, destroy, opName, 0);
    }

    public ReturnResult recycle(int start, int size) {
        String url = this.URL_API_RECYCLE_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult recover(String[] fullpaths, String opName, int opId) {
        String url = this.URL_API_RECOVER_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpaths", Util.strArrayToString((String[])fullpaths, (String)"|"));
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult recover(String[] fullpaths, String opName) {
        return this.recover(fullpaths, opName, 0);
    }

    public ReturnResult delCompletely(String[] fullpaths, String opName, int opId) {
        String url = this.URL_API_DEL_COMPLETELY_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpaths", Util.strArrayToString((String[])fullpaths, (String)"|"));
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delCompletely(String[] fullpaths, String opName) {
        return this.delCompletely(fullpaths, opName, 0);
    }

    public ReturnResult move(String fullpath, String destfullpath, String opName, int opId) {
        String url = this.URL_API_MOVE_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("dest_fullpath", destfullpath);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult move(String fullpath, String destfullpath, String opName) {
        return this.move(fullpath, destfullpath, opName, 0);
    }

    public ReturnResult history(String fullpath, int start, int size) {
        String url = this.URL_API_HISTORY_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult link(String fullpath, int deadline, AuthType authType, String password, String opName, int opId) {
        String url = this.URL_API_LINK_FILE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        if (deadline != 0) {
            params.put("deadline", Integer.toString(deadline));
        }
        if (!authType.equals((Object)AuthType.DEFAULT)) {
            params.put("auth", authType.toString().toLowerCase());
        }
        params.put("password", password);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult linkCloseByCode(String code, String opName, int opId) {
        String url = this.URL_API_LINK_CLOSE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult linkCloseByFullpath(String fullpath, String opName, int opId) {
        String url = this.URL_API_LINK_CLOSE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult link(String fullpath, int deadline, AuthType authType, String password, String opName) {
        return this.link(fullpath, deadline, authType, password, opName, 0);
    }

    public ReturnResult links(boolean fileOnly) {
        String url = this.URL_API_GET_LINK;
        HashMap<String, String> params = new HashMap<String, String>();
        if (fileOnly) {
            params.put("file", "1");
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getUpdateCounts(long beginDateline, long endDateline, boolean showDelete) {
        String url = this.URL_API_UPDATE_COUNT;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("begin_dateline", Long.toString(beginDateline));
        params.put("end_dateline", Long.toString(endDateline));
        params.put("showdel", showDelete ? "1" : "0");
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getUploadServers(String fullpath, int timeout) {
        String url = this.URL_API_UPLOAD_SERVERS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("timeout", Integer.toString(timeout));
        params.put("rand", Integer.toString(new Random().nextInt(100000)));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getServerSite(String type) {
        String url = this.URL_API_GET_SERVER_SITE;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult search(String keyWords, String path, int start, int size, ScopeType ... scopes) {
        String url = this.URL_API_FILE_SEARCH;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keywords", keyWords);
        params.put("path", path);
        if (scopes != null) {
            params.put("scope", new Gson().toJson((Object)scopes).toLowerCase());
        }
        params.put("start", Integer.toString(start));
        params.put("size", Integer.toString(size));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getDownloadUrlByHash(String hash, boolean isOpen, NetType net, String opName) {
        return this.getDownloadUrl(hash, null, isOpen, net, null, opName, 0);
    }

    public ReturnResult getDownloadUrlByHash(String hash, String opName) {
        return this.getDownloadUrl(hash, null, false, NetType.DEFAULT, null, opName, 0);
    }

    public ReturnResult getDownloadUrlByFullpath(String fullpath, boolean isOpen, NetType net, String opName) {
        return this.getDownloadUrl(null, fullpath, isOpen, net, null, opName, 0);
    }

    public ReturnResult getDownloadUrlByFullpath(String fullpath, String opName) {
        return this.getDownloadUrl(null, fullpath, false, NetType.DEFAULT, null, opName, 0);
    }

    public ReturnResult getDownloadUrl(String hash, String fullpath, boolean isOpen, NetType net, String fileName, String opName, int opId) {
        String url = this.URL_API_GET_UPLOAD_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        params.put("filename", fileName);
        params.put("open", isOpen ? "1" : "0");
        switch (net) {
            case DEFAULT: {
                break;
            }
            case IN: {
                params.put("net", net.name().toLowerCase());
            }
        }
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getPreviewUrlByFullpath(String fullpath, boolean showWatermark, String memberName, String opName) {
        return this.getPreviewUrl(null, fullpath, showWatermark, memberName, opName, 0);
    }

    public ReturnResult getPreviewUrlByFullpath(String fullpath, boolean showWatermark, String memberName, int opId) {
        return this.getPreviewUrl(null, fullpath, showWatermark, memberName, null, opId);
    }

    public ReturnResult getPreviewUrlByHash(String hash, boolean showWatermark, String memberName, String opName) {
        return this.getPreviewUrl(hash, null, showWatermark, memberName, opName, 0);
    }

    public ReturnResult getPreviewUrlByHash(String hash, boolean showWatermark, String memberName, int opId) {
        return this.getPreviewUrl(hash, null, showWatermark, memberName, null, opId);
    }

    public ReturnResult getPreviewUrl(String hash, String fullpath, boolean showWatermark, String memberName, String opName, int opId) {
        String url = this.URL_API_PREVIEW_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        params.put("member_name", memberName);
        params.put("watermark", showWatermark ? "1" : "0");
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getAnnotationUrlByFullpath(String fullpath, String outId) {
        return this.getAnnotationUrl(null, fullpath, outId, 0);
    }

    public ReturnResult getAnnotationUrlByFullpath(String fullpath, int opId) {
        return this.getAnnotationUrl(null, fullpath, null, opId);
    }

    public ReturnResult getAnnotationUrlByHash(String hash, String outId) {
        return this.getAnnotationUrl(hash, null, outId, 0);
    }

    public ReturnResult getAnnotationUrlByHash(String hash, int opId) {
        return this.getAnnotationUrl(hash, null, null, opId);
    }

    public ReturnResult getAnnotationUrl(String hash, String fullpath, String outId, int opId) {
        String url = this.URL_API_PREVIEW_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        params.put("fullpath", fullpath);
        params.put("annotation", "display");
        if (opId > 0) {
            params.put("op_id", Integer.toString(opId));
        } else if (!Util.isEmpty((CharSequence)outId)) {
            params.put("out_id", outId);
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getPermission(String fullpath, int memberId) {
        String url = this.URL_API_GET_PERMISSION;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("member_id", Integer.toString(memberId));
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setPermission(String fullpath, int memberId, String opName, int opId, FilePermissions ... permissions) {
        String url = this.URL_API_SET_PERMISSION;
        HashMap<String, String> params = new HashMap<String, String>();
        if (permissions != null) {
            HashMap map = new HashMap();
            ArrayList<String> list = new ArrayList<String>();
            for (FilePermissions p : permissions) {
                list.add(p.toString().toLowerCase());
            }
            map.put(memberId, list);
            params.put("permissions", new Gson().toJson(map));
        }
        params.put("fullpath", fullpath);
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setPermission(String fullpath, int memberId, String opName, FilePermissions ... permissions) {
        return this.setPermission(fullpath, memberId, opName, 0, permissions);
    }

    public ReturnResult addTag(String fullpath, String[] tags, String opName, int opId) {
        String url = this.URL_API_ADD_TAG;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("tag", Util.strArrayToString((String[])tags, (String)";"));
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult addTag(String fullpath, String[] tags, String opName) {
        return this.addTag(fullpath, tags, opName, 0);
    }

    public ReturnResult delTag(String fullpath, String[] tags, String opName, int opId) {
        String url = this.URL_API_DEL_TAG;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("tag", Util.strArrayToString((String[])tags, (String)";"));
        this.setOp(params, opName, opId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delTag(String fullpath, String[] tags, String opName) {
        return this.delTag(fullpath, tags, opName, 0);
    }

    public ReturnResult stat() {
        String url = this.URL_API_STAT;
        return new EntEngine.RequestHelper(this).setUrl(url).setMethod(RequestMethod.GET).executeSync();
    }

    public ReturnResult getCeditUrl(String clientId, String hash, String fullpath, Integer readonly, Integer timeout, String opId, String outId, String account) {
        String url = this.URL_API_CEDIT_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        if (readonly != null) {
            params.put("readonly", readonly.toString());
        }
        Integer default_timeout = 3600;
        if (timeout != null) {
            default_timeout = timeout;
        }
        params.put("timeout", default_timeout.toString());
        if (opId != null && !Util.isEmpty((CharSequence)opId)) {
            params.put("op_id", opId);
        } else if (outId != null && !Util.isEmpty((CharSequence)outId)) {
            params.put("out_id", outId);
        } else {
            params.put("account", account);
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setPermissionInherit(String clientId, String fullpath, fileInherit inherit) {
        String url = this.URL_API_SET_PERMISSION_INHERIT;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        params.put("inherit", inherit.toString());
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getAllPermission(String clientId, String fullpath) {
        String url = this.URL_API_GET_ALL_PERMISSION;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult resetPermission(String clientId, String fullpath, int[] memberIds, int[] groupIds, Integer clear) {
        String url = this.URL_API_RESET_PERMISSION;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fullpath", fullpath);
        if (memberIds != null && memberIds.length > 0) {
            params.put("members", Util.intArrayToString((int[])memberIds, (String)","));
        }
        if (groupIds != null && groupIds.length > 0) {
            params.put("groups", Util.intArrayToString((int[])groupIds, (String)","));
        }
        if (clear != null && clear > 0) {
            params.put("clear", clear.toString());
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult setMetadata(String clientId, String hash, String fullpath, String key, String metadata, String[] display) {
        String url = this.URL_API_SET_METADATA;
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        params.put("key", key);
        params.put("metadata", metadata);
        if (display != null && display.length > 0) {
            params.put("display", Util.strArrayToString((String[])display, (String)","));
        }
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult delMetadata(String clientId, String hash, String fullpath, String key) {
        String url = this.URL_API_DEL_METADATA;
        HashMap<String, String> params = new HashMap<String, String>();
        if (hash != null && !Util.isEmpty((CharSequence)hash)) {
            params.put("hash", hash);
        } else {
            params.put("fullpath", fullpath);
        }
        params.put("key", key);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getQueueStatus(String clientId, String queueId) {
        String url = this.URL_API_QUEUE_STATUS;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queue_id", queueId);
        return new EntEngine.RequestHelper(this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public static enum fileInherit {
        INHERIT("1"),
        UNINHERIT("0");

        private String fileInherit;

        private fileInherit(String fileInherit2) {
            this.fileInherit = fileInherit2;
        }

        public String toString() {
            return this.fileInherit;
        }
    }

    public static enum NetType {
        DEFAULT,
        IN;

    }

    public static enum AuthType {
        DEFAULT,
        PREVIEW,
        DOWNLOAD,
        UPLOAD;

    }
}

