/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.NetConnection;
import com.gokuai.base.utils.Util;
import com.yunkuent.sdk.EntFileManager;
import com.yunkuent.sdk.HostConfig;
import com.yunkuent.sdk.UploadManager;
import java.net.Proxy;

public class ConfigHelper {
    private String mOauthHost;
    private String mWebHost;
    private String mApiHost;
    private String mUploadRootPath;
    private String mUploadOpName;
    private Proxy mProxy;
    private String mUserAgent;
    private boolean mTrustSsl = false;
    private String mLanguage;
    private long mConnectTimeout;
    private long mTimeout;
    private int mBlockSize;
    private int mRetry;

    public ConfigHelper apiHost(String apiHost) {
        this.mApiHost = apiHost;
        return this;
    }

    public ConfigHelper oauthHost(String oauthHost) {
        this.mOauthHost = oauthHost;
        return this;
    }

    public ConfigHelper webHost(String webHost) {
        this.mWebHost = webHost;
        return this;
    }

    public ConfigHelper uploadRootPath(String uploadRootPath) {
        this.mUploadRootPath = uploadRootPath;
        return this;
    }

    public ConfigHelper uploadOpName(String uploadOpName) {
        this.mUploadOpName = uploadOpName;
        return this;
    }

    public ConfigHelper proxy(Proxy proxy) {
        this.mProxy = proxy;
        return this;
    }

    public ConfigHelper userAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    public ConfigHelper trustSsl(boolean trust) {
        this.mTrustSsl = trust;
        return this;
    }

    public ConfigHelper language(String language) {
        this.mLanguage = language;
        return this;
    }

    public ConfigHelper blockSize(int blockSize) {
        this.mBlockSize = blockSize;
        return this;
    }

    public ConfigHelper connectTimeout(long timeoutSeconds) {
        this.mConnectTimeout = timeoutSeconds;
        return this;
    }

    public ConfigHelper timeout(long timeoutSeconds) {
        this.mTimeout = timeoutSeconds;
        return this;
    }

    public ConfigHelper retry(int retry) {
        if (retry > 0) {
            this.mRetry = retry;
        }
        return this;
    }

    public void config() {
        if (!Util.isEmpty((CharSequence)this.mApiHost)) {
            HostConfig.API_ENT_HOST = this.mApiHost;
        }
        if (!Util.isEmpty((CharSequence)this.mOauthHost)) {
            HostConfig.OAUTH_HOST = this.mOauthHost;
        }
        if (!Util.isEmpty((CharSequence)this.mWebHost)) {
            HostConfig.WEB_HOST = this.mWebHost;
        }
        if (this.mProxy != null) {
            NetConnection.setProxy((Proxy)this.mProxy);
        }
        if (!Util.isEmpty((CharSequence)this.mUserAgent)) {
            NetConnection.setUserAgent((String)this.mUserAgent);
        }
        NetConnection.trustSsl((boolean)this.mTrustSsl);
        if (this.mConnectTimeout > 0L) {
            NetConnection.setConnectTimeout((long)this.mConnectTimeout);
        }
        if (this.mTimeout > 0L) {
            NetConnection.setTimeout((long)this.mTimeout);
        }
        if (!Util.isEmpty((CharSequence)this.mLanguage)) {
            NetConnection.setAcceptLanguage((String)this.mLanguage);
        }
        if (!Util.isEmpty((CharSequence)this.mUploadOpName)) {
            EntFileManager.DEFAULT_OPNAME = this.mUploadOpName;
        }
        if (!Util.isEmpty((CharSequence)this.mUploadRootPath)) {
            EntFileManager.UPLOAD_ROOT_PATH = this.mUploadRootPath + (this.mUploadRootPath.endsWith("/") ? "" : "/");
        }
        if (this.mBlockSize > 0) {
            EntFileManager.DEFAULT_BLOCKSIZE = this.mBlockSize;
        }
        if (this.mRetry > 0) {
            NetConnection.setRetry((int)this.mRetry);
            UploadManager.setRetry(this.mRetry);
        }
    }
}

