/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.HttpEngine;
import com.gokuai.base.LogPrint;
import com.gokuai.base.NetConnection;
import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.URLEncoder;
import com.gokuai.base.utils.Util;
import com.yunkuent.sdk.data.FileInfo;
import com.yunkuent.sdk.data.YunkuException;
import com.yunkuent.sdk.upload.IEntFileManager;
import com.yunkuent.sdk.upload.UploadCallback;
import com.yunkuent.sdk.utils.YKUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.CRC32;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class UploadManager {
    private static final String LOG_TAG = "UploadManager ";
    private static final String URL_UPLOAD_INIT = "/upload_init";
    private static final String URL_UPLOAD_REQ = "/upload_req";
    private static final String URL_UPLOAD_PART = "/upload_part";
    private static final String URL_UPLOAD_ABORT = "/upload_abort";
    private static final String URL_UPLOAD_FINISH = "/upload_finish";
    private static final String URL_UPLOAD_ALL = "/upload_all";
    private static int RETRY = 0;
    private final int mBlockSize;
    private String mSession = "";
    private HttpEngine mEngine;
    private String mLocalFile;
    private String mFullpath;
    private String mOpName;
    private int mOpId;
    private boolean mOverwrite;
    private OkHttpClient mUploadHttpClient;
    private UploadCallback mCallback;
    private InputStream mStream;
    private FileInfo mFileinfo = new FileInfo();
    private boolean mIsStop;

    public static void setRetry(int retry) {
        RETRY = retry;
    }

    public UploadManager(int blockSize, HttpEngine engine) {
        this.mBlockSize = blockSize;
        this.mEngine = engine;
    }

    public void setOperator(int opId) {
        this.mOpId = opId;
    }

    public void setOperator(String opName) {
        this.mOpName = opName;
    }

    public FileInfo upload(String localFile, String fullpath, boolean overwrite) throws YunkuException {
        this.mLocalFile = localFile;
        this.mFullpath = fullpath;
        this.mOverwrite = overwrite;
        return this.doUpload();
    }

    public FileInfo upload(InputStream stream, String fullpath, boolean overwrite) throws YunkuException {
        this.mStream = stream;
        this.mFullpath = fullpath;
        this.mOverwrite = overwrite;
        return this.doUpload();
    }

    public void uploadAsync(String localFile, String fullpath, boolean overwrite, UploadCallback callback) {
        this.mLocalFile = localFile;
        this.mFullpath = fullpath;
        this.mOverwrite = overwrite;
        this.mCallback = callback;
        this.doUploadAsync();
    }

    public void uploadAsync(InputStream stream, String fullpath, boolean overwrite, UploadCallback callback) {
        this.mStream = stream;
        this.mFullpath = fullpath;
        this.mOverwrite = overwrite;
        this.mCallback = callback;
        this.doUploadAsync();
    }

    private FileInfo doUpload() throws YunkuException {
        try {
            this.startUpload();
            FileInfo fileInfo = this.mFileinfo;
            return fileInfo;
        }
        catch (IOException e) {
            LogPrint.error((String)LOG_TAG, (String)e.getMessage());
            throw new YunkuException(e);
        }
        finally {
            if (this.mStream != null) {
                try {
                    this.mStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doUploadAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UploadManager.this.startUpload();
                    if (UploadManager.this.mCallback != null) {
                        UploadManager.this.mCallback.onProgress(UploadManager.this.mFullpath, 1.0f);
                        UploadManager.this.mCallback.onSuccess(UploadManager.this.mFullpath, UploadManager.this.mFileinfo);
                    }
                }
                catch (YunkuException e) {
                    LogPrint.error((String)UploadManager.LOG_TAG, (String)e.getMessage());
                    if (UploadManager.this.mCallback != null) {
                        UploadManager.this.mCallback.onFail(UploadManager.this.mFullpath, e);
                    }
                }
                catch (IOException e) {
                    LogPrint.error((String)UploadManager.LOG_TAG, (String)e.getMessage());
                    if (UploadManager.this.mCallback != null) {
                        UploadManager.this.mCallback.onFail(UploadManager.this.mFullpath, new YunkuException(e));
                    }
                }
                finally {
                    if (UploadManager.this.mStream != null) {
                        try {
                            UploadManager.this.mStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }).start();
    }

    private void startUpload() throws YunkuException, IOException {
        if (this.mStream != null) {
            this.mStream = Util.cloneInputStream((InputStream)this.mStream);
            FileInfo fileInfo = YKUtils.getFileSha1(this.mStream, false);
            this.mFileinfo.fileHash = fileInfo.fileHash;
            this.mFileinfo.fileSize = fileInfo.fileSize;
        } else if (!Util.isEmpty((CharSequence)this.mLocalFile)) {
            File file = new File(this.mLocalFile);
            if (!file.exists()) {
                throw new YunkuException(this.mLocalFile + " not found");
            }
            if (!file.canRead()) {
                throw new YunkuException(this.mLocalFile + " can not read");
            }
            this.mFileinfo.fileHash = Util.getFileSha1((String)this.mLocalFile);
            this.mFileinfo.fileSize = file.length();
            this.mStream = new FileInputStream(this.mLocalFile);
        }
        if (this.mStream == null) {
            throw new YunkuException("fail to open file stream");
        }
        for (int trys = 0; trys < 3; ++trys) {
            ReturnResult result = ((IEntFileManager)this.mEngine).createFile(this.mFullpath, this.mFileinfo.fileHash, this.mFileinfo.fileSize, this.mOverwrite, this.mOpName, this.mOpId);
            boolean shouldUpload = this.decodeAddFileResult(result);
            if (!shouldUpload) {
                return;
            }
            if (Util.isEmpty((CharSequence)this.mFileinfo.uploadServer)) {
                throw new YunkuException("fail to get upload server", result);
            }
            LogPrint.info((String)LOG_TAG, (String)("The server is " + this.mFileinfo.uploadServer));
            if (this.mBlockSize == 0) {
                this.uploadAll();
                return;
            }
            result = this.uploadInit();
            if (result == null) continue;
            if (result.getCode() == 202) {
                return;
            }
            long checkSize = this.uploadReq();
            if (checkSize < 0L) continue;
            if (checkSize == this.mFileinfo.fileSize) break;
            long offset = checkSize;
            boolean uploadPartErr = false;
            CRC32 crc = new CRC32();
            this.mStream.skip(offset);
            while (offset < this.mFileinfo.fileSize - 1L && !this.mIsStop) {
                if (this.mCallback != null) {
                    this.mCallback.onProgress(this.mFullpath, (float)offset / (float)this.mFileinfo.fileSize);
                }
                int buflen = offset + (long)this.mBlockSize > this.mFileinfo.fileSize ? (int)(this.mFileinfo.fileSize - offset) : this.mBlockSize;
                byte[] buffer = new byte[buflen];
                this.mStream.read(buffer);
                crc.update(buffer);
                long crc32 = crc.getValue();
                crc.reset();
                long range_end = offset + (long)buflen - 1L;
                String range = offset + "-" + range_end;
                result = this.uploadPart(range, buffer, crc32);
                System.gc();
                int code = result.getCode();
                if (code == 200) {
                    offset += (long)buflen;
                    continue;
                }
                if (code == 202) break;
                if (code >= 500) {
                    uploadPartErr = true;
                    break;
                }
                if (code == 401) {
                    uploadPartErr = true;
                    break;
                }
                if (code == 409) {
                    JSONObject json = new JSONObject(result.getBody());
                    offset = Long.parseLong(json.getString("expect"));
                    this.mStream.skip(offset);
                    continue;
                }
                throw new YunkuException("fail to call upload_part", result);
            }
            if (this.mIsStop) {
                throw new YunkuException("upload stopped");
            }
            if (!uploadPartErr) break;
        }
        this.uploadFinish();
    }

    private boolean decodeAddFileResult(ReturnResult result) throws YunkuException {
        if (!result.isOK() || Util.isEmpty((CharSequence)result.getBody())) {
            throw new YunkuException("fail to get upload server", result);
        }
        try {
            JSONObject json = new JSONObject(result.getBody());
            this.mFileinfo.fullpath = json.getString("fullpath");
            this.mFileinfo.filename = Util.getNameFromPath((String)this.mFileinfo.fullpath);
            this.mFileinfo.hash = json.getString("hash");
            this.mFileinfo.uploadServer = json.optString("server");
            int state = json.optInt("state");
            return state == 0;
        }
        catch (Exception e) {
            throw new YunkuException("fail to decode create_file result", result);
        }
    }

    private ReturnResult uploadAll() throws YunkuException {
        byte[] uploadData;
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_ALL + "?org_client_id=" + this.mEngine.getClientId();
        Headers.Builder headerBuilder = new Headers.Builder();
        headerBuilder.set("x-gk-upload-pathhash", this.mFileinfo.hash);
        headerBuilder.set("x-gk-upload-filename", URLEncoder.encodeUTF8((String)this.mFileinfo.filename));
        headerBuilder.set("x-gk-upload-filehash", this.mFileinfo.fileHash);
        headerBuilder.set("x-gk-upload-filesize", String.valueOf(this.mFileinfo.fileSize));
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = this.mStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            uploadData = buffer.toByteArray();
        }
        catch (IOException e) {
            throw new YunkuException("fail to load upload data", new ReturnResult((Exception)e));
        }
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])uploadData);
        Request request = requestBuilder.url(url).put(requestBody).headers(headerBuilder.build()).build();
        int retry = RETRY;
        while (true) {
            try {
                Response resp = this.getUploadHttpClient().newCall(request).execute();
                return new ReturnResult(resp.code(), resp.body().string());
            }
            catch (IOException e) {
                if (retry-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw new YunkuException("fail to call upload_all", new ReturnResult((Exception)e));
            }
            break;
        }
    }

    private ReturnResult uploadInit() throws YunkuException {
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_INIT + "?org_client_id=" + this.mEngine.getClientId();
        HashMap<String, String> headParams = new HashMap<String, String>();
        headParams.put("x-gk-upload-pathhash", this.mFileinfo.hash);
        headParams.put("x-gk-upload-filename", URLEncoder.encodeUTF8((String)this.mFileinfo.filename));
        headParams.put("x-gk-upload-filehash", this.mFileinfo.fileHash);
        headParams.put("x-gk-upload-filesize", String.valueOf(this.mFileinfo.fileSize));
        ReturnResult result = new HttpEngine.RequestHelper(this.mEngine).setHeaders(headParams).setUrl(url).setMethod(RequestMethod.POST).disableSign().executeSync();
        if (result.isOK()) {
            JSONObject json = new JSONObject(result.getBody());
            this.mSession = json.optString("session");
            if (Util.isEmpty((CharSequence)this.mSession)) {
                throw new YunkuException("fail to get session in uploadInit", result);
            }
        } else {
            if (result.getCode() >= 500) {
                return null;
            }
            if (result.getCode() != 202) {
                throw new YunkuException("fail to call upload_init", result);
            }
        }
        return result;
    }

    private long uploadReq() throws YunkuException {
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_REQ;
        HashMap<String, String> headParams = new HashMap<String, String>();
        headParams.put("x-gk-upload-session", this.mSession);
        long checkSize = 0L;
        ReturnResult result = new HttpEngine.RequestHelper(this.mEngine).setHeaders(headParams).setUrl(url).setMethod(RequestMethod.GET).disableSign().executeSync();
        if (result.isOK()) {
            try {
                checkSize = Long.parseLong(result.getBody());
            }
            catch (Exception e) {
                checkSize = 0L;
            }
        } else if (result.getCode() >= 500) {
            checkSize = -1L;
        } else {
            throw new YunkuException("fail to call upload_req", result);
        }
        return checkSize;
    }

    private ReturnResult uploadPart(String range, byte[] content, long crc32) throws YunkuException {
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_PART;
        Headers.Builder headerBuilder = new Headers.Builder();
        headerBuilder.add("Connection", "Keep-Alive");
        headerBuilder.add("x-gk-upload-session", this.mSession);
        headerBuilder.add("x-gk-upload-range", range);
        headerBuilder.add("x-gk-upload-crc", String.valueOf(crc32));
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])content);
        Request request = requestBuilder.url(url).put(requestBody).headers(headerBuilder.build()).build();
        int retry = RETRY;
        while (true) {
            try {
                Response resp = this.getUploadHttpClient().newCall(request).execute();
                return new ReturnResult(resp.code(), resp.body().string());
            }
            catch (IOException e) {
                if (retry-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw new YunkuException("fail to call upload_part", new ReturnResult((Exception)e));
            }
            break;
        }
    }

    private OkHttpClient getUploadHttpClient() {
        if (this.mUploadHttpClient == null) {
            this.mUploadHttpClient = NetConnection.getOkHttpClient();
        }
        return this.mUploadHttpClient;
    }

    private ReturnResult uploadFinish() throws YunkuException {
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_FINISH;
        HashMap<String, String> headParams = new HashMap<String, String>();
        headParams.put("x-gk-upload-session", this.mSession);
        ReturnResult result = null;
        int retry = 10;
        while (retry-- > 0) {
            result = new HttpEngine.RequestHelper(this.mEngine).setHeaders(headParams).setUrl(url).setMethod(RequestMethod.POST).disableSign().executeSync();
            if (result.getCode() != 202) break;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (result.isOK()) {
            return result;
        }
        throw new YunkuException("fail to call upload_finish", result);
    }

    private void uploadAbort() {
        if (Util.isEmpty((CharSequence)this.mFileinfo.uploadServer) || Util.isEmpty((CharSequence)this.mSession)) {
            return;
        }
        String url = this.mFileinfo.uploadServer + URL_UPLOAD_ABORT;
        HashMap<String, String> headParams = new HashMap<String, String>();
        headParams.put("x-gk-upload-session", this.mSession);
        new HttpEngine.RequestHelper(this.mEngine).setHeaders(headParams).setUrl(url).setMethod(RequestMethod.POST).disableSign().executeSync();
    }

    public void stop() {
        this.mIsStop = true;
    }
}

