/*
 * Decompiled with CFR 0.152.
 */
package com.yunkuent.sdk;

import com.gokuai.base.HttpEngine;
import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.Util;
import com.yunkuent.sdk.HostConfig;
import java.util.HashMap;

public class ThirdPartyManager
extends HttpEngine {
    private final String URL_API_CREATE_ENT = HostConfig.OAUTH_HOST + "/1/thirdparty/create_ent";
    private final String URL_API_ENT_INFO = HostConfig.OAUTH_HOST + "/1/thirdparty/ent_info";
    private final String URL_API_ORDER = HostConfig.OAUTH_HOST + "/1/thirdparty/order";
    private final String URL_GET_TOKEN = HostConfig.OAUTH_HOST + "/1/thirdparty/get_token";
    private final String URL_GET_SSO_URL = HostConfig.OAUTH_HOST + "/1/thirdparty/get_sso_url";
    public final String SUBSCRIBE = "orderSubscribe";
    public final String UPGRADE = "orderUpgrade";
    public final String RENEW = "orderRenew";
    public final String UNSUBSCRIBE = "orderUnsubscribe";
    public static String OUT_ID = "";

    public ThirdPartyManager(String clientId, String clientSecret, String outId) {
        super(clientId, clientSecret);
        OUT_ID = outId;
    }

    public ReturnResult createEnt(String entName, String contactName, String contactMobile, String contactEmail, String contactAddress) {
        return this.createEnt(null, entName, contactName, contactMobile, contactEmail, contactAddress);
    }

    public ReturnResult createEnt(HashMap<String, String> map, String entName, String contactName, String contactMobile, String contactEmail, String contactAddress) {
        String url = this.URL_API_CREATE_ENT;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.mClientId);
        params.put("out_id", OUT_ID);
        params.put("ent_name", entName);
        params.put("contact_name", contactName);
        params.put("contact_mobile", contactMobile);
        params.put("contact_email", contactEmail);
        params.put("contact_address", contactAddress);
        params.put("dateline", Util.getUnixDateline() + "");
        if (map != null) {
            params.putAll(map);
        }
        params.put("sign", this.generateSign(params));
        return new HttpEngine.RequestHelper((HttpEngine)this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getEntInfo() {
        String url = this.URL_API_ENT_INFO;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.mClientId);
        params.put("out_id", OUT_ID);
        params.put("dateline", Util.getUnixDateline() + "");
        params.put("sign", this.generateSign(params));
        return new HttpEngine.RequestHelper((HttpEngine)this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult orderUpgrade(int memberCount, int space) {
        return this.order("orderUpgrade", memberCount, space, 0);
    }

    public ReturnResult orderRenew(int month) {
        return this.order("orderRenew", -1, 0, month);
    }

    public ReturnResult orderUnsubscribe() {
        return this.order("orderUnsubscribe", -1, 0, 0);
    }

    public ReturnResult orderSubscribe(int memberCount, int space, int month) {
        return this.order("orderSubscribe", memberCount, space, month);
    }

    private ReturnResult order(String type, int memberCount, int space, int month) {
        String url = this.URL_API_ORDER;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.mClientId);
        params.put("out_id", OUT_ID);
        if (!Util.isEmpty((CharSequence)type)) {
            params.put("type", type);
            if ("orderSubscribe".equals(type)) {
                params.put("member_count", memberCount + "");
                params.put("space", space + "");
                params.put("month", month + "");
            } else if ("orderUpgrade".equals(type)) {
                params.put("member_count", memberCount + "");
                params.put("space", space + "");
            } else if ("orderRenew".equals(type)) {
                params.put("month", month + "");
            }
        }
        params.put("dateline", Util.getUnixDateline() + "");
        params.put("sign", this.generateSign(params));
        return new HttpEngine.RequestHelper((HttpEngine)this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getEntToken() {
        String url = this.URL_GET_TOKEN;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.mClientId);
        params.put("out_id", OUT_ID);
        params.put("dateline", Util.getUnixDateline() + "");
        params.put("sign", this.generateSign(params));
        return new HttpEngine.RequestHelper((HttpEngine)this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }

    public ReturnResult getSsoUrl(String ticket) {
        String url = this.URL_GET_SSO_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.mClientId);
        params.put("out_id", OUT_ID);
        params.put("ticket", ticket);
        params.put("dateline", Util.getUnixDateline() + "");
        params.put("sign", this.generateSign(params));
        return new HttpEngine.RequestHelper((HttpEngine)this).setParams(params).setUrl(url).setMethod(RequestMethod.POST).executeSync();
    }
}

