/*
 * Decompiled with CFR 0.152.
 */
package com.gokuai.base.utils;

import com.gokuai.base.utils.Base64;
import com.gokuai.base.utils.URLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Util {
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String encodeBase64Replace(String str) {
        return Base64.encodeBytes(str.getBytes()).replace('=', '!').replace('+', '-').replace('/', '|');
    }

    public static String decodeBase64Replace(String str) {
        try {
            return Base64.decode(str.replace('!', '=').replace('-', '+').replace('|', '/').getBytes()).toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertStreamToFile(InputStream inputStream, String filePath) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(filePath));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static String convert2MD532(String str) {
        String md5Str = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            md5Str = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return md5Str;
    }

    public static String arrayListToString(ArrayList<String> arraylist, String conv) {
        String strReturn = "";
        int size = arraylist.size();
        if (size > 0) {
            for (int i = 0; i < size - 1; ++i) {
                strReturn = strReturn + arraylist.get(i) + conv;
            }
            strReturn = strReturn + arraylist.get(size - 1);
        }
        return strReturn;
    }

    public static String ArrayToString(Object[] array, String conv) {
        String strReturn = "";
        int length = array.length;
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                strReturn = strReturn + array[i].toString() + conv;
            }
            strReturn = strReturn + array[length - 1].toString();
        }
        return strReturn;
    }

    public static String strArrayToString(String[] strArray, String conv) {
        String strReturn = "";
        int length = strArray.length;
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                strReturn = strReturn + strArray[i] + conv;
            }
            strReturn = strReturn + strArray[length - 1];
        }
        return strReturn;
    }

    public static String intArrayToString(int[] intArray, String conv) {
        String strReturn = "";
        int length = intArray.length;
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                strReturn = strReturn + intArray[i] + conv;
            }
            strReturn = strReturn + intArray[length - 1];
        }
        return strReturn;
    }

    public static String getHmacSha1(String data, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] text = mac.doFinal(data.getBytes("UTF-8"));
            String result = Base64.encodeBytes(text);
            return result.trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getPathLastIndex(String fileName) {
        int point = fileName.lastIndexOf(47);
        if (point == -1) {
            point = fileName.lastIndexOf(92);
        }
        return point;
    }

    public static int getPathLastIndex(String fileName, int fromIndex) {
        int point = fileName.lastIndexOf(47, fromIndex);
        if (point == -1) {
            point = fileName.lastIndexOf(92, fromIndex);
        }
        return point;
    }

    public static String getPathPart(String fileName) {
        int point = Util.getPathLastIndex(fileName);
        int length = fileName.length();
        if (point == -1) {
            return "";
        }
        if (point == length - 1) {
            int secondPoint = Util.getPathLastIndex(fileName, point - 1);
            if (secondPoint == -1) {
                return "";
            }
            return fileName.substring(0, secondPoint);
        }
        return fileName.substring(0, point);
    }

    public static String getNameFromPath(String filePath) {
        int index = Util.getPathLastIndex(filePath);
        if (index == -1) {
            return filePath;
        }
        return filePath.substring(index + 1);
    }

    public static String getTargetFolderName(String folderPath) {
        if (folderPath.equals("")) {
            return "";
        }
        folderPath = folderPath.substring(0, folderPath.length() - 1);
        return Util.getNameFromPath(folderPath);
    }

    public static long getUnixDateline() {
        Calendar ca = Calendar.getInstance(Locale.US);
        return ca.getTimeInMillis() / 1000L;
    }

    protected static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(String path) {
        String filehash = "";
        File file = new File(path);
        if (file.exists()) {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    MessageDigest messagedigest = MessageDigest.getInstance("SHA-1");
                    byte[] buffer = new byte[0xA00000];
                    int len = 0;
                    while ((len = in.read(buffer)) > 0) {
                        messagedigest.update(buffer, 0, len);
                    }
                    filehash = Util.toHexString(messagedigest.digest());
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filehash;
    }

    public static InputStream cloneInputStream(InputStream inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static String mapToQueryString(HashMap<String, String> params) {
        String paramsString = "";
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (value == null) continue;
                paramsString = paramsString + "&" + key + "=" + URLEncoder.encodeUTF8(value);
            }
            if (paramsString.startsWith("&")) {
                paramsString = paramsString.substring(1);
            }
        }
        return paramsString;
    }

    public static boolean isEmpty(CharSequence s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }
}

