/*
 * Decompiled with CFR 0.152.
 */
package com.gokuai.base.utils;

public class SHA1 {
    private static final boolean hexcase = false;
    private static final int chrsz = 8;

    public static String hex_sha1(String s) {
        s = s == null ? "" : s;
        return SHA1.binb2hex(SHA1.core_sha1(SHA1.str2binb(s), s.length() * 8));
    }

    private static String binb2hex(int[] binarray) {
        String hex_tab = "0123456789abcdef";
        String str = "";
        for (int i = 0; i < binarray.length * 4; ++i) {
            char a = hex_tab.charAt(binarray[i >> 2] >> (3 - i % 4) * 8 + 4 & 0xF);
            char b = hex_tab.charAt(binarray[i >> 2] >> (3 - i % 4) * 8 & 0xF);
            str = str + new Character(a).toString() + new Character(b).toString();
        }
        return str;
    }

    private static String binb2str(int[] bin) {
        String str = "";
        int mask = 255;
        for (int i = 0; i < bin.length * 32; i += 8) {
            str = str + (char)(bin[i >> 5] >>> 24 - i % 32 & mask);
        }
        return str;
    }

    private static int[] core_sha1(int[] x, int len) {
        int size = len >> 5;
        x = SHA1.strechbinarray(x, size);
        int n = len >> 5;
        x[n] = x[n] | 128 << 24 - len % 32;
        size = (len + 64 >> 9 << 4) + 15;
        x = SHA1.strechbinarray(x, size);
        x[(len + 64 >> 9 << 4) + 15] = len;
        int[] w = new int[80];
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int e = -1009589776;
        for (int i = 0; i < x.length; i += 16) {
            int olda = a;
            int oldb = b;
            int oldc = c;
            int oldd = d;
            int olde = e;
            for (int j = 0; j < 80; ++j) {
                w[j] = j < 16 ? x[i + j] : SHA1.rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
                int t = SHA1.safe_add(SHA1.safe_add(SHA1.rol(a, 5), SHA1.sha1_ft(j, b, c, d)), SHA1.safe_add(SHA1.safe_add(e, w[j]), SHA1.sha1_kt(j)));
                e = d;
                d = c;
                c = SHA1.rol(b, 30);
                b = a;
                a = t;
            }
            a = SHA1.safe_add(a, olda);
            b = SHA1.safe_add(b, oldb);
            c = SHA1.safe_add(c, oldc);
            d = SHA1.safe_add(d, oldd);
            e = SHA1.safe_add(e, olde);
        }
        int[] retval = new int[]{a, b, c, d, e};
        return retval;
    }

    private static int rol(int num, int cnt) {
        return num << cnt | num >>> 32 - cnt;
    }

    private static int safe_add(int x, int y) {
        int lsw = (x & 0xFFFF) + (y & 0xFFFF);
        int msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return msw << 16 | lsw & 0xFFFF;
    }

    private static int sha1_ft(int t, int b, int c, int d) {
        if (t < 20) {
            return b & c | ~b & d;
        }
        if (t < 40) {
            return b ^ c ^ d;
        }
        if (t < 60) {
            return b & c | b & d | c & d;
        }
        return b ^ c ^ d;
    }

    private static int sha1_kt(int t) {
        return t < 20 ? 1518500249 : (t < 40 ? 1859775393 : (t < 60 ? -1894007588 : -899497514));
    }

    public static String str_sha1(String s) {
        s = s == null ? "" : s;
        return SHA1.binb2str(SHA1.core_sha1(SHA1.str2binb(s), s.length() * 8));
    }

    private static int[] str2binb(String str) {
        str = str == null ? "" : str;
        int[] tmp = new int[str.length() * 8];
        int mask = 255;
        for (int i = 0; i < str.length() * 8; i += 8) {
            int n = i >> 5;
            tmp[n] = tmp[n] | (str.charAt(i / 8) & mask) << 24 - i % 32;
        }
        int len = 0;
        int i = 0;
        while (i < tmp.length && tmp[i] != 0) {
            ++i;
            ++len;
        }
        int[] bin = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            bin[i2] = tmp[i2];
        }
        return bin;
    }

    private static int[] strechbinarray(int[] oldbin, int size) {
        int i;
        int currlen = oldbin.length;
        if (currlen >= size + 1) {
            return oldbin;
        }
        int[] newbin = new int[size + 1];
        for (i = 0; i < size; ++i) {
            newbin[i] = 0;
        }
        for (i = 0; i < currlen; ++i) {
            newbin[i] = oldbin[i];
        }
        return newbin;
    }
}

