/*
 * Decompiled with CFR 0.152.
 */
package com.gokuai.base;

import com.gokuai.base.LogPrint;
import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.utils.Base64;
import com.gokuai.base.utils.Util;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class NetConnection {
    private static final String LOG_TAG = "NetConnection";
    private static final String USER_AGENT = "YunkuJavaSDK;" + System.getProperties().getProperty("http.agent");
    private static Proxy mProxy = null;
    private static String mUserAgent = null;
    private static String mAcceptLanguage = "zh-CN";
    private static long mTimeout = 1800L;
    private static long mConnectTimeout = 10L;
    private static int mRetry = 0;
    private static boolean mTrustSsl = false;
    private static OkHttpClient mHttpClient = null;
    private static final String URL_ENCODE = "application/x-www-form-urlencoded; charset=utf-8";
    private static final String JSON_STRING = "application/json; charset=utf-8";
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private static final SSLContext trustAllSslContext;
    private static final SSLSocketFactory trustAllSslSocketFactory;

    private NetConnection() {
    }

    public static void setUserAgent(String userAgent) {
        mUserAgent = userAgent;
    }

    public static String getUserAgent() {
        return Util.isEmpty(mUserAgent) ? USER_AGENT : USER_AGENT + ";" + mUserAgent;
    }

    public static void trustSsl(boolean trust) {
        mTrustSsl = trust;
    }

    public static void setAcceptLanguage(String acceptLanguage) {
        mAcceptLanguage = acceptLanguage;
    }

    public static void setTimeout(long timeout) {
        mTimeout = timeout;
    }

    public static void setConnectTimeout(long timeout) {
        mConnectTimeout = timeout;
    }

    public static void setProxy(Proxy proxy) {
        mProxy = proxy;
    }

    public static void setRetry(int retry) {
        mRetry = retry;
    }

    public static ReturnResult sendRequest(String url, RequestMethod method, HashMap<String, String> params, HashMap<String, String> headParams) {
        return NetConnection.sendRequest(url, method, params, headParams, "post_default_form_type");
    }

    public static ReturnResult sendRequest(String url, RequestMethod method, HashMap<String, String> params, HashMap<String, String> headerMap, String postType) {
        Request request;
        LogPrint.debug(LOG_TAG, "sendRequest(): url is: " + url + " params" + params + ", headers, " + headerMap);
        String paramsString = "";
        MediaType contentType = null;
        if (postType.equals("post_default_form_type")) {
            paramsString = Util.mapToQueryString(params);
            contentType = MediaType.parse((String)URL_ENCODE);
        } else if (postType.equals("post_json_type")) {
            paramsString = new Gson().toJson(params);
            contentType = MediaType.parse((String)JSON_STRING);
        }
        Headers.Builder headerBuilder = new Headers.Builder();
        headerBuilder.set("User-Agent", NetConnection.getUserAgent());
        headerBuilder.set("Accept-Language", mAcceptLanguage);
        if (headerMap != null) {
            for (String key : headerMap.keySet()) {
                String value = headerMap.get(key);
                if (value == null) continue;
                headerBuilder.set(key, value);
            }
        }
        Headers headers = headerBuilder.build();
        LogPrint.debug(LOG_TAG, (Object)((Object)method) + " " + url + " " + paramsString + " " + headers.toString());
        if (method.equals((Object)RequestMethod.GET)) {
            if (!Util.isEmpty(paramsString)) {
                url = url + (url.indexOf("?") > 0 ? "&" : "?") + paramsString;
            }
            request = new Request.Builder().get().url(url).headers(headers).build();
        } else if (method.equals((Object)RequestMethod.POST) || method.equals((Object)RequestMethod.PUT)) {
            RequestBody postBody = RequestBody.create((MediaType)contentType, (String)paramsString);
            request = new Request.Builder().method(method.toString(), postBody).url(url).headers(headers).build();
        } else {
            return null;
        }
        int statusCode = 0;
        String body = "";
        int retry = mRetry;
        while (true) {
            try {
                OkHttpClient client = NetConnection.getOkHttpClient();
                Response resp = client.newCall(request).execute();
                if (resp.header("X-GOKUAI-DEBUG") != null) {
                    try {
                        LogPrint.debug(LOG_TAG, "X-GOKUAI-DEBUG: " + new String(Base64.decode(resp.header("X-GOKUAI-DEBUG").getBytes())));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                statusCode = resp.code();
                body = resp.body().string();
                if (Util.isEmpty(body)) break;
                String response = body;
                if (response.length() > 1000) {
                    response = body.substring(0, 1000);
                }
                LogPrint.debug(LOG_TAG, "response: " + response);
            }
            catch (IOException e) {
                LogPrint.error(LOG_TAG, e.getMessage());
                if (retry-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                return new ReturnResult(e);
            }
            break;
        }
        return new ReturnResult(statusCode, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getOkHttpClient() {
        if (mHttpClient != null) return mHttpClient;
        Class<NetConnection> clazz = NetConnection.class;
        synchronized (NetConnection.class) {
            if (mHttpClient != null) return mHttpClient;
            OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
            if (mTrustSsl) {
                builder.sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]);
                builder.hostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (mProxy != null) {
                builder.proxy(mProxy);
            }
            builder.connectTimeout(mConnectTimeout, TimeUnit.SECONDS);
            builder.readTimeout(mTimeout, TimeUnit.SECONDS);
            builder.writeTimeout(mTimeout, TimeUnit.SECONDS);
            mHttpClient = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mHttpClient;
        }
    }

    static {
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        trustAllSslSocketFactory = trustAllSslContext.getSocketFactory();
    }
}

