/*
 * Decompiled with CFR 0.152.
 */
package com.gokuai.base;

import com.gokuai.base.DefaultAsyncTarget;
import com.gokuai.base.IAsyncTarget;
import com.gokuai.base.IAuthRequest;
import com.gokuai.base.LogPrint;
import com.gokuai.base.NetConnection;
import com.gokuai.base.RequestMethod;
import com.gokuai.base.ReturnResult;
import com.gokuai.base.SignAbility;
import com.gokuai.base.utils.Util;
import java.util.HashMap;

public abstract class HttpEngine
extends SignAbility {
    public static final int ERRORID_NETDISCONNECT = 1;
    private static final String LOG_TAG = "HttpEngine";

    public HttpEngine(String clientId, String secret) {
        super(clientId, secret);
    }

    public class RequestHelper {
        String url;
        RequestMethod method = RequestMethod.POST;
        protected HashMap<String, String> params;
        HashMap<String, String> headers;
        boolean checkAuth;
        String postType = "post_default_form_type";
        IAsyncTarget target;
        boolean disableSign = false;

        public RequestHelper setMethod(RequestMethod method) {
            this.method = method;
            return this;
        }

        public RequestHelper setParams(HashMap<String, String> params) {
            this.params = params;
            return this;
        }

        public RequestHelper setHeaders(HashMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RequestHelper setCheckAuth(boolean checkAuth) {
            this.checkAuth = checkAuth;
            return this;
        }

        public RequestHelper setPostType(String postType) {
            this.postType = postType;
            return this;
        }

        public RequestHelper setUrl(String url) {
            this.url = url;
            return this;
        }

        public RequestHelper setTarget(IAsyncTarget target) {
            this.target = target;
            return this;
        }

        public RequestHelper disableSign() {
            this.disableSign = true;
            return this;
        }

        protected void setCommonParams() {
            if (this.disableSign) {
                return;
            }
            if (this.params == null) {
                this.params = new HashMap();
            }
            this.params.put("sign", HttpEngine.this.generateSign(this.params));
        }

        private void checkNecessaryParams() {
            if (Util.isEmpty(this.url)) {
                throw new IllegalArgumentException("url must not be null");
            }
            this.setCommonParams();
        }

        public ReturnResult executeSync() {
            this.checkNecessaryParams();
            if (this.checkAuth) {
                if (HttpEngine.this instanceof IAuthRequest) {
                    return ((IAuthRequest)((Object)HttpEngine.this)).sendRequestWithAuth(this.url, this.method, this.params, this.headers, this.postType);
                }
                LogPrint.error(HttpEngine.LOG_TAG, "You need implement IAuthRequest before set checkAuth=true");
            }
            return NetConnection.sendRequest(this.url, this.method, this.params, this.headers, this.postType);
        }

        public IAsyncTarget executeAsync(DataListener listener, int apiId, RequestHelperCallback callback) {
            this.checkNecessaryParams();
            if (this.target != null) {
                return this.target.execute(listener, this, callback, apiId);
            }
            return new DefaultAsyncTarget().execute(listener, this, callback, apiId);
        }

        public IAsyncTarget executeAsync(DataListener listener, int apiId) {
            return this.executeAsync(listener, apiId, null);
        }
    }

    public static interface RequestHelperCallback {
        public ReturnResult hook(ReturnResult var1);
    }

    public static interface DataListener {
        public void onReceivedData(int var1, ReturnResult var2, int var3);
    }
}

