/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.timing.timer.HashedWheelBucket;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class HashedWheelTimeout
implements Timeout,
Runnable {
    static final int ST_INIT = 0;
    static final int ST_CANCELLED = 1;
    static final int ST_EXPIRED = 2;
    private static final AtomicIntegerFieldUpdater<HashedWheelTimeout> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimeout.class, "state");
    protected final HashedWheelTimer timer;
    protected final TimerTask task;
    protected final long deadline;
    private volatile int state = 0;
    long remainingRounds;
    HashedWheelTimeout next;
    HashedWheelTimeout prev;
    HashedWheelBucket bucket;

    public HashedWheelTimeout(HashedWheelTimer timer, TimerTask task, long deadline) {
        this.timer = timer;
        this.task = task;
        this.deadline = deadline;
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public TimerTask task() {
        return this.task;
    }

    @Override
    public boolean cancel() {
        if (!this.compareAndSetState(0, 1)) {
            return false;
        }
        this.timer.cancelledTimeouts.add(this);
        return true;
    }

    void remove() {
        HashedWheelBucket bucket = this.bucket;
        if (bucket != null) {
            bucket.remove(this);
        } else {
            this.timer.pendingTimeouts.decrementAndGet();
        }
    }

    public boolean compareAndSetState(int expected, int state) {
        return STATE_UPDATER.compareAndSet(this, expected, state);
    }

    public int state() {
        return this.state;
    }

    @Override
    public boolean isCancelled() {
        return this.state() == 1;
    }

    @Override
    public boolean isExpired() {
        return this.state() == 2;
    }

    public void expire() {
        block3: {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.executeTask();
            }
            catch (Throwable t) {
                if (!HashedWheelTimer.logger.isWarnEnabled()) break block3;
                HashedWheelTimer.logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
            }
        }
    }

    protected void executeTask() {
        this.timer.getTaskExecutor().execute(this);
    }

    @Override
    public void run() {
        block2: {
            try {
                this.task.run(this);
            }
            catch (Throwable t) {
                if (!HashedWheelTimer.logger.isWarnEnabled()) break block2;
                HashedWheelTimer.logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
            }
        }
    }

    public String toString() {
        long currentTime = System.nanoTime();
        long remaining = this.deadline - currentTime + this.timer.startTime;
        StringBuilder buf = new StringBuilder(192).append(Reflects.getSimpleClassName(this)).append('(').append("deadline: ");
        if (remaining > 0L) {
            buf.append(remaining).append(" ns later");
        } else if (remaining < 0L) {
            buf.append(-remaining).append(" ns ago");
        } else {
            buf.append("now");
        }
        if (this.isCancelled()) {
            buf.append(", cancelled");
        }
        return buf.append(", task: ").append(this.task()).append(')').toString();
    }
}

