/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.util.timing.timer.HashedWheelTimeout;
import com.jn.langx.util.timing.timer.Timeout;
import java.util.Set;

public final class HashedWheelBucket {
    private HashedWheelTimeout head;
    private HashedWheelTimeout tail;

    public void addTimeout(HashedWheelTimeout timeout) {
        assert (timeout.bucket == null);
        timeout.bucket = this;
        if (this.head == null) {
            this.head = this.tail = timeout;
        } else {
            this.tail.next = timeout;
            timeout.prev = this.tail;
            this.tail = timeout;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expireTimeouts(long deadline) {
        HashedWheelTimeout timeout = this.head;
        while (timeout != null) {
            HashedWheelTimeout next = timeout.next;
            if (timeout.remainingRounds <= 0L) {
                next = this.remove(timeout);
                if (timeout.deadline > deadline) throw new IllegalStateException(String.format("timeout.deadline (%d) > deadline (%d)", timeout.deadline, deadline));
                timeout.expire();
            } else if (timeout.isCancelled()) {
                next = this.remove(timeout);
            } else {
                --timeout.remainingRounds;
            }
            timeout = next;
        }
    }

    public HashedWheelTimeout remove(HashedWheelTimeout timeout) {
        HashedWheelTimeout next = timeout.next;
        if (timeout.prev != null) {
            timeout.prev.next = next;
        }
        if (timeout.next != null) {
            timeout.next.prev = timeout.prev;
        }
        if (timeout == this.head) {
            if (timeout == this.tail) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = next;
            }
        } else if (timeout == this.tail) {
            this.tail = timeout.prev;
        }
        timeout.prev = null;
        timeout.next = null;
        timeout.bucket = null;
        timeout.timer.pendingTimeouts.decrementAndGet();
        return next;
    }

    public void clearTimeouts(Set<Timeout> set) {
        HashedWheelTimeout timeout;
        while ((timeout = this.pollTimeout()) != null) {
            if (timeout.isExpired() || timeout.isCancelled()) continue;
            set.add(timeout);
        }
        return;
    }

    private HashedWheelTimeout pollTimeout() {
        HashedWheelTimeout head = this.head;
        if (head == null) {
            return null;
        }
        HashedWheelTimeout next = head.next;
        if (next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = next;
            next.prev = null;
        }
        head.next = null;
        head.prev = null;
        head.bucket = null;
        return head;
    }
}

