/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing;

import com.jn.langx.annotation.Nullable;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private final String id;
    private boolean keepTaskList;
    private final List<TaskInfo> taskList = new LinkedList<TaskInfo>();
    private long startTimeMillis;
    @Nullable
    private String currentTaskName;
    @Nullable
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeMillis;

    public StopWatch() {
        this("");
    }

    public StopWatch(String id) {
        this(id, true);
    }

    public StopWatch(String id, boolean keepTaskList) {
        this.id = id;
        this.setKeepTaskList(keepTaskList);
    }

    public static StopWatch createAndStart() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch createAndStart(String id) {
        StopWatch stopWatch = new StopWatch(id);
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch createAndStart(String id, boolean keepTaskList) {
        StopWatch stopWatch = new StopWatch(id, keepTaskList);
        stopWatch.start();
        return stopWatch;
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    public void start(String taskName) throws IllegalStateException {
        if (this.currentTaskName != null) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.currentTaskName = taskName;
        this.startTimeMillis = System.currentTimeMillis();
    }

    public void stop() throws IllegalStateException {
        if (this.currentTaskName == null) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long now = System.currentTimeMillis();
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, this.startTimeMillis, now);
        this.totalTimeMillis += this.lastTaskInfo.getTimeMillis();
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    @Nullable
    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getDurationTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.getId() + "': running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append(nf.format(task.getDurationTimeMillis())).append("  ");
                sb.append(pf.format(task.getTimeSeconds() / this.getTotalTimeSeconds())).append("  ");
                sb.append(task.getTaskName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        if (this.keepTaskList) {
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getDurationTimeMillis());
                long percent = Math.round(100.0 * task.getTimeSeconds() / this.getTotalTimeSeconds());
                sb.append(" = ").append(percent).append("%");
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long startTimeMills;
        private final long endTimeMills;
        private final long durationTimeMillis;

        TaskInfo(String taskName, long startTimeMills) {
            this(taskName, startTimeMills, System.currentTimeMillis());
        }

        TaskInfo(String taskName, long startTimeMills, long endTimeMillis) {
            this.taskName = taskName;
            this.startTimeMills = startTimeMills;
            this.endTimeMills = endTimeMillis;
            this.durationTimeMillis = endTimeMillis - startTimeMills;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.durationTimeMillis;
        }

        public long getStartTimeMills() {
            return this.startTimeMills;
        }

        public long getEndTimeMills() {
            return this.endTimeMills;
        }

        public long getDurationTimeMillis() {
            return this.durationTimeMillis;
        }

        public double getTimeSeconds() {
            return (double)this.durationTimeMillis / 1000.0;
        }
    }
}

