/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.type;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.signature.TypeSignatures;
import com.jn.langx.util.reflect.type.ParameterizedTypeImpl;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class Types {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static boolean isPrimitive(Type type) {
        return Primitives.isPrimitive(type);
    }

    public static boolean isArray(Type type) {
        return Types.isClass(type) && ((Class)type).isArray();
    }

    public static boolean isClass(Type type) {
        return type instanceof Class;
    }

    public static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static Class getPrimitiveWrapClass(Type type) {
        return Primitives.wrap(type);
    }

    public static String typeToString(Type type) {
        if (type instanceof Class) {
            Class<?> ctype = (Class<?>)type;
            if (ctype.isArray()) {
                try {
                    Class<?> cl = ctype;
                    int dimensions = 0;
                    while (cl.isArray()) {
                        ++dimensions;
                        cl = cl.getComponentType();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(cl.getName());
                    for (int i = 0; i < dimensions; ++i) {
                        sb.append("[]");
                    }
                    return sb.toString();
                }
                catch (Throwable throwable) {}
            } else {
                return ctype.getName();
            }
        }
        return type.toString();
    }

    public static String getTypeSignature(@NonNull String typeString) {
        return TypeSignatures.toTypeSignature(typeString);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new ParameterizedTypeImpl.GenericArrayTypeImpl(componentType);
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return Types.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return Types.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Preconditions.checkTrue(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            return Array.newInstance(Types.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
        }
        if (Types.isPrimitive(o)) {
            return Types.getPrimitiveWrapClass(o);
        }
        if (Types.isClass(o)) {
            return (Class)o;
        }
        if (Types.isParameterizedType(o)) {
            ParameterizedType type = (ParameterizedType)o;
            return Types.getParameterizedTypeWithOwnerType(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments()).getClass();
        }
        throw new IllegalArgumentException();
    }

    public static ParameterizedType getSetParameterizedType(Type elementType) {
        return Types.getParameterizedType(Set.class, new Type[]{elementType});
    }

    public static ParameterizedType getListParameterizedType(Type elementType) {
        return Types.getParameterizedType(List.class, new Type[]{elementType});
    }

    public static ParameterizedType getMapParameterizedType(Type keyType, Type valueType) {
        return Types.getParameterizedType(Map.class, new Type[]{keyType, valueType});
    }

    public static ParameterizedType getParameterizedType(Type rawType) {
        return new ParameterizedTypeImpl(null, rawType, new Type[0]);
    }

    public static ParameterizedType getParameterizedType(Type rawType, Type ... typeArguments) {
        return Types.getParameterizedTypeWithOwnerType(null, rawType, typeArguments);
    }

    public static ParameterizedType getParameterizedTypeWithOwnerType(Type ownerType, Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        StringBuilder prefix = new StringBuilder("[");
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix.append("[");
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        Type original;
        while (toResolve instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)toResolve;
            if ((toResolve = Types.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
            return toResolve;
        }
        if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
            Type newComponentType;
            original = (Class)toResolve;
            Class<?> componentType = ((Class)original).getComponentType();
            return componentType == (newComponentType = Types.resolve(context, contextRawType, componentType)) ? original : Types.arrayOf(newComponentType);
        }
        if (toResolve instanceof GenericArrayType) {
            Type newComponentType;
            original = (GenericArrayType)toResolve;
            Type componentType = original.getGenericComponentType();
            return componentType == (newComponentType = Types.resolve(context, contextRawType, componentType)) ? original : Types.arrayOf(newComponentType);
        }
        if (toResolve instanceof ParameterizedType) {
            original = (ParameterizedType)toResolve;
            Type ownerType = original.getOwnerType();
            Type newOwnerType = Types.resolve(context, contextRawType, ownerType);
            boolean changed = newOwnerType != ownerType;
            Type[] args = original.getActualTypeArguments();
            int length = args.length;
            for (int t = 0; t < length; ++t) {
                Type resolvedTypeArgument = Types.resolve(context, contextRawType, args[t]);
                if (resolvedTypeArgument == args[t]) continue;
                if (!changed) {
                    args = (Type[])args.clone();
                    changed = true;
                }
                args[t] = resolvedTypeArgument;
            }
            return changed ? new ParameterizedTypeImpl(newOwnerType, original.getRawType(), args) : original;
        }
        if (toResolve instanceof WildcardType) {
            Type upperBound;
            original = (WildcardType)toResolve;
            Type[] originalLowerBound = original.getLowerBounds();
            Type[] originalUpperBound = original.getUpperBounds();
            if (originalLowerBound.length == 1) {
                Type lowerBound = Types.resolve(context, contextRawType, originalLowerBound[0]);
                if (lowerBound != originalLowerBound[0]) {
                    return Types.supertypeOf(lowerBound);
                }
            } else if (originalUpperBound.length == 1 && (upperBound = Types.resolve(context, contextRawType, originalUpperBound[0])) != originalUpperBound[0]) {
                return Types.subtypeOf(upperBound);
            }
            return original;
        }
        return toResolve;
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    private static int indexOf(Object[] array, Object toFind) {
        for (int i = 0; i < array.length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = Types.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = Types.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = Types.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    public static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!Reflects.isSubClassOrEquals(toResolve, interfaces[i])) continue;
                return Types.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (Reflects.isSubClassOrEquals(toResolve, rawSupertype)) {
                    return Types.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static WildcardType subtypeOf(Type bound) {
        return new ParameterizedTypeImpl.WildcardTypeImpl(new Type[]{bound}, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        return new ParameterizedTypeImpl.WildcardTypeImpl(new Type[]{Object.class}, new Type[]{bound});
    }

    public static boolean isLiteralType(Type type) {
        if (Primitives.isPrimitive(type) || Primitives.isWrapperType(type)) {
            return true;
        }
        if (Types.isClass(type)) {
            return type == String.class;
        }
        return false;
    }

    static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        if (context instanceof WildcardType) {
            context = ((WildcardType)context).getUpperBounds()[0];
        }
        Preconditions.checkArgument(supertype.isAssignableFrom(contextRawType));
        return Types.resolve(context, contextRawType, Types.getGenericSupertype(context, contextRawType, supertype));
    }

    public static Type getArrayComponentType(Type array) {
        return array instanceof GenericArrayType ? ((GenericArrayType)array).getGenericComponentType() : ((Class)array).getComponentType();
    }

    public static Type getCollectionElementType(Type context, Class<?> contextRawType) {
        Type collectionType = Types.getSupertype(context, contextRawType, Collection.class);
        if (collectionType instanceof WildcardType) {
            collectionType = ((WildcardType)collectionType).getUpperBounds()[0];
        }
        if (collectionType instanceof ParameterizedType) {
            return ((ParameterizedType)collectionType).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type context, Class<?> contextRawType) {
        if (context == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        Type mapType = Types.getSupertype(context, contextRawType, Map.class);
        if (mapType instanceof ParameterizedType) {
            ParameterizedType mapParameterizedType = (ParameterizedType)mapType;
            return mapParameterizedType.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }
}

