/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.type;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class ParameterizedTypeGetter<T> {
    private Type rawType;
    private Type[] actualTypeArguments;

    protected ParameterizedTypeGetter() {
        this.parseSuperclassTypeParameter(this.getClass());
    }

    private ParameterizedTypeGetter(Type type) {
        this.rawType = type;
        if (Types.isParameterizedType(type)) {
            this.actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            this.rawType = ((ParameterizedType)type).getRawType();
        }
    }

    private void parseSuperclassTypeParameter(Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof Class) {
            throw new RuntimeException(StringTemplates.formatWithPlaceholder("{} is not a parameterized type", Reflects.getFQNClassName(clazz)));
        }
        this.actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        if (this.actualTypeArguments.length > 0) {
            Type rawType = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
            if (rawType instanceof ParameterizedType) {
                rawType = ((ParameterizedType)rawType).getRawType();
            }
            this.rawType = rawType;
        } else {
            this.rawType = clazz;
        }
    }

    public static ParameterizedTypeGetter forType(Type type) {
        return new ParameterizedTypeGetter(type){};
    }

    public final Type getRawType() {
        return this.rawType;
    }

    public final Type getActualArgumentType(int index) {
        Preconditions.checkIndex(index, this.actualTypeArguments == null ? 0 : this.actualTypeArguments.length);
        return this.actualTypeArguments[index];
    }

    public final Type getType() {
        return this.getActualArgumentType(0);
    }

    public String toString() {
        return this.rawType.toString();
    }
}

