/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.reference;

import com.jn.langx.util.Objects;
import com.jn.langx.util.struct.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class HashedWeakReference<V>
extends WeakReference<V>
implements Reference<V> {
    private int hash;

    public HashedWeakReference(V referent, Integer hash) {
        super(referent);
        this.setHash(hash == null ? (referent == null ? 0 : referent.hashCode()) : hash);
    }

    public HashedWeakReference(V referent, ReferenceQueue<? super V> q, Integer hash) {
        super(referent, q);
        this.setHash(hash == null ? (referent == null ? 0 : referent.hashCode()) : hash);
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public void setHash(int hash) {
        this.hash = hash;
    }

    @Override
    public boolean isNull() {
        return this.get() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedWeakReference that = (HashedWeakReference)o;
        if (this.hash != that.hash) {
            return false;
        }
        return Objects.equals(this.get(), that.get());
    }

    public int hashCode() {
        return this.hash;
    }
}

