/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.ExceptionMessage;
import com.jn.langx.util.Chars;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.ParameterServiceRegistry;
import com.jn.langx.util.reflect.parameter.ConstructorParameter;
import com.jn.langx.util.reflect.parameter.MethodParameter;
import com.jn.langx.util.reflect.signature.TypeSignatures;
import com.jn.langx.util.reflect.type.Types;
import com.jn.langx.util.struct.Holder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflects {
    private static final Pattern lamdbaPattern = Pattern.compile(".*\\$\\$Lambda\\$[0-9]+/.*");
    private static final Logger logger = LoggerFactory.getLogger(Reflects.class);
    private static final Method OBJECT_EQUALS = Reflects.getDeclaredMethod(Object.class, "equals", Object.class);
    private static final Method OBJECT_HASHCODE = Reflects.getDeclaredMethod(Object.class, "hashCode", new Class[0]);
    private static final ParameterServiceRegistry PARAMETER_SERVICE_REGISTRY = ParameterServiceRegistry.getInstance();

    public static String getTypeName(@NonNull Class type) {
        return Types.typeToString(type);
    }

    public static boolean isInnerClass(@NonNull Class<?> clazz) {
        return clazz.isMemberClass() && !Reflects.isStatic(clazz) && clazz.getEnclosingClass() != null;
    }

    public static boolean isLambda(@NonNull Class<?> clazz) {
        return clazz != null && clazz.isSynthetic() && lamdbaPattern.matcher(Reflects.getSimpleClassName(clazz)).matches();
    }

    public static boolean isStatic(@NonNull Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    public static boolean isAnonymousOrLocal(@NonNull Class<?> clazz) {
        return Reflects.isAnonymous(clazz) || Reflects.isLocal(clazz);
    }

    public static boolean isAnonymous(@NonNull Class clazz) {
        return !Reflects.isSubClassOrEquals(Enum.class, clazz) && clazz.isAnonymousClass();
    }

    public static boolean isLocal(@NonNull Class clazz) {
        return !Reflects.isSubClassOrEquals(Enum.class, clazz) && clazz.isLocalClass();
    }

    public static boolean isConcrete(@NonNull Class clazz) {
        return !clazz.isInterface() && !Modifiers.isAbstract(clazz);
    }

    public static Class<? extends Member> memberType(Member member) {
        Preconditions.checkNotNull(member, "member");
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }

    public static String getSimpleClassName(@NonNull Object obj) {
        return Reflects.getSimpleClassName(obj.getClass());
    }

    public static String getSimpleClassName(@NonNull Class clazz) {
        return clazz.getSimpleName();
    }

    public static String getFQNClassName(@NonNull Class clazz) {
        return clazz.getName();
    }

    public static String getPackageName(@NonNull String classFullName) {
        int index = classFullName.lastIndexOf(46);
        if (index != -1) {
            return classFullName.substring(0, index);
        }
        return "";
    }

    public static String getPackageName(@NonNull Class clazz) {
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            return pkg.getName();
        }
        String className = Reflects.getFQNClassName(clazz);
        return Reflects.getPackageName(className);
    }

    public static String getJvmSignature(@NonNull Class clazz) {
        return TypeSignatures.toTypeSignature(Reflects.getFQNClassName(clazz));
    }

    public static String getCodeLocationString(@NonNull Class clazz) {
        URL url = Reflects.getCodeLocation(clazz);
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public static URL getCodeLocation(@NonNull Class clazz) {
        Preconditions.checkNotNull(clazz);
        if (Types.isArray(clazz)) {
            return Reflects.getCodeLocation(clazz.getComponentType());
        }
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource codeSource = pd.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }

    private static void getAllInterfaces(@NonNull Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                Reflects.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static Iterable<Class<?>> hierarchy(@NonNull Class<?> type) {
        Preconditions.checkNotNull(type);
        return Reflects.hierarchy(type, true);
    }

    public static Iterable<Class<?>> hierarchy(final @NonNull Class<?> type, boolean excludeInterfaces) {
        Preconditions.checkNotNull(type);
        final Iterable classes = new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                final Holder<Class> next = new Holder<Class>(type);
                return new Iterator<Class<?>>(){

                    @Override
                    public boolean hasNext() {
                        return next.get() != null;
                    }

                    @Override
                    public Class<?> next() {
                        Class result = (Class)next.get();
                        next.set(result.getSuperclass());
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (excludeInterfaces) {
            return classes;
        }
        return new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                final HashSet seenInterfaces = new HashSet();
                final Iterator wrapped = classes.iterator();
                return new Iterator<Class<?>>(){
                    Iterator<Class<?>> interfaces = Collects.emptyTreeSet().iterator();

                    @Override
                    public boolean hasNext() {
                        return this.interfaces.hasNext() || wrapped.hasNext();
                    }

                    @Override
                    public Class<?> next() {
                        if (this.interfaces.hasNext()) {
                            Class<?> nextInterface = this.interfaces.next();
                            seenInterfaces.add(nextInterface);
                            return nextInterface;
                        }
                        Class nextSuperclass = (Class)wrapped.next();
                        LinkedHashSet currentInterfaces = new LinkedHashSet();
                        this.walkInterfaces(currentInterfaces, nextSuperclass);
                        this.interfaces = currentInterfaces.iterator();
                        return nextSuperclass;
                    }

                    private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                        for (Class<?> iface : c.getInterfaces()) {
                            if (!seenInterfaces.contains(iface)) {
                                addTo.add(iface);
                            }
                            this.walkInterfaces(addTo, iface);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static boolean isAnnotationPresent(@NonNull AnnotatedElement annotatedElement, @NonNull Class<? extends Annotation> annotationClass) {
        return annotatedElement.isAnnotationPresent(annotationClass);
    }

    public static <E extends Annotation> boolean hasAnnotation(@NonNull AnnotatedElement annotatedElement, @NonNull Class<E> annotationClass) {
        return Reflects.getAnnotation(annotatedElement, annotationClass) != null;
    }

    public static <E extends Annotation> E getAnnotation(@NonNull AnnotatedElement annotatedElement, @NonNull Class<E> annotationClass) {
        return annotatedElement.getAnnotation(annotationClass);
    }

    public static <E extends Annotation> E getDeclaredAnnotation(@NonNull AnnotatedElement annotatedElement, @NonNull Class<E> annotationClass) {
        return Reflects.getAnnotation(annotatedElement, annotationClass);
    }

    public static Annotation[] getAnnotations(@NonNull AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotations();
    }

    public static List<Annotation> getDeclaredAnnotations(@NonNull AnnotatedElement annotatedElement) {
        return Collects.asList(annotatedElement.getDeclaredAnnotations());
    }

    public static Field getStaticField(@NonNull Class clazz, @NonNull String fieldName) {
        Field field = Reflects.getDeclaredField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        if (Modifiers.isStatic(field)) {
            return field;
        }
        return null;
    }

    public static Field getPublicField(@NonNull Class clazz, @NonNull String fieldName) {
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Field getDeclaredField(@NonNull Class clazz, @NonNull String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Field getAnyField(@NonNull Class clazz, @NonNull String fieldName) {
        Field field = Reflects.getDeclaredField(clazz, fieldName);
        if (field == null) {
            Class parent = clazz.getSuperclass();
            if (parent != null) {
                return Reflects.getAnyField(parent, fieldName);
            }
            return null;
        }
        return field;
    }

    public static Collection<Field> getAllDeclaredFields(@NonNull Class clazz) {
        return Reflects.getAllDeclaredFields(clazz, false);
    }

    public static Collection<Field> getAllDeclaredFields(@NonNull Class clazz, boolean containsStatic) {
        Field[] fields = clazz.getDeclaredFields();
        return !containsStatic ? Reflects.filterFields(fields, 8) : Reflects.filterFields(fields, new int[0]);
    }

    public static Collection<Field> getAllPublicInstanceFields(@NonNull Class clazz) {
        return Reflects.getAllPublicFields(clazz, false);
    }

    public static Collection<Field> getAllPublicFields(@NonNull Class clazz, boolean containsStatic) {
        Field[] fields = clazz.getFields();
        return !containsStatic ? Reflects.filterFields(fields, 8) : Reflects.filterFields(fields, new int[0]);
    }

    public static Collection<Field> filterFields(@NonNull Field[] fields, int ... excludedModifiers) {
        final List<Integer> excludedModifierList = Collects.asList(PrimitiveArrays.wrap(excludedModifiers, false));
        return Collects.filter(fields, new Predicate<Field>(){

            @Override
            public boolean test(final Field field) {
                return Collects.noneMatch(excludedModifierList, new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer modifier) {
                        return Modifiers.hasModifier(field, (int)modifier);
                    }
                });
            }
        });
    }

    public static <V> V getPublicFieldValueForcedIfPresent(@NonNull Object object, @NonNull String fieldName) {
        try {
            return Reflects.getPublicFieldValue(object, fieldName, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V getPublicFieldValue(@NonNull Object object, @NonNull String fieldName, boolean throwException) {
        try {
            Field field = Reflects.getPublicField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find public field {0} in the class {1}", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
                return null;
            }
            return (V)field.get(object);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V getDeclaredFieldValueForcedIfPresent(@NonNull Object object, @NonNull String fieldName) {
        try {
            return Reflects.getDeclaredFieldValue(object, fieldName, true, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V getDeclaredFieldValue(@NonNull Object object, String fieldName, boolean force, boolean throwException) {
        try {
            Field field = Reflects.getDeclaredField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find a declared field {0} in the class {1}", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
                return null;
            }
            return Reflects.getFieldValue(field, object, force, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V getAnyFieldValueForcedIfPresent(@NonNull Object object, @NonNull String fieldName) {
        try {
            return Reflects.getAnyFieldValue(object, fieldName, true, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V getAnyFieldValue(@NonNull Object object, @NonNull String fieldName, boolean force, boolean throwException) {
        try {
            Field field = Reflects.getAnyField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find a declared field {0} in the class {1} and its all super class", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
                return null;
            }
            return Reflects.getFieldValue(field, object, force, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V getFieldValue(@NonNull Field field, @NonNull Object object, boolean force, boolean throwException) {
        try {
            if (!force && !field.isAccessible()) {
                if (throwException) {
                    throw new IllegalAccessException();
                }
                return null;
            }
            if (field.isAccessible()) {
                try {
                    return (V)field.get(object);
                }
                catch (IllegalArgumentException ex) {
                    if (throwException) {
                        throw ex;
                    }
                    return null;
                }
            }
            field.setAccessible(true);
            try {
                return (V)field.get(object);
            }
            catch (IllegalArgumentException ex) {
                if (throwException) {
                    throw ex;
                }
                return null;
            }
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static void setFieldValue(@NonNull Field field, @NonNull Object target, Object value, boolean force, boolean throwException) {
        block14: {
            try {
                if (Emptys.isEmpty(field)) {
                    if (throwException) {
                        Preconditions.checkNotNull(field);
                    }
                    break block14;
                }
                if (!force && !field.isAccessible()) {
                    if (throwException) {
                        throw new IllegalAccessException();
                    }
                    return;
                }
                if (field.isAccessible()) {
                    if (throwException) {
                        field.set(target, value);
                    } else {
                        try {
                            field.set(target, value);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return;
                }
                field.setAccessible(true);
                try {
                    field.set(target, value);
                }
                catch (Throwable ex) {
                    if (throwException) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            catch (Throwable ex) {
                throw Throwables.wrapAsRuntimeException(ex);
            }
        }
    }

    public static void setPublicFieldValue(@NonNull Object object, @NonNull String fieldName, Object value, boolean force, boolean throwException) {
        try {
            Field field = Reflects.getPublicField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find a declared field {0} in the class {1} and its all super class", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
            } else {
                Reflects.setFieldValue(field, object, value, force, throwException);
            }
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static void setDeclaredFieldValue(@NonNull Object object, @NonNull String fieldName, Object value, boolean force, boolean throwException) {
        try {
            Field field = Reflects.getDeclaredField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find a declared field {0} in the class {1} and its all super class", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
            } else {
                Reflects.setFieldValue(field, object, value, force, throwException);
            }
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static void setAnyFieldValue(@NonNull Object object, @NonNull String fieldName, Object value, boolean force, boolean throwException) {
        try {
            Field field = Reflects.getAnyField(object.getClass(), fieldName);
            if (field == null) {
                if (throwException) {
                    throw new NoSuchFieldException(new ExceptionMessage("Can't find a declared field {0} in the class {1} and its all super class", fieldName, object.getClass().getCanonicalName()).getMessage());
                }
            } else {
                Reflects.setFieldValue(field, object, value, force, throwException);
            }
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <E> boolean hasConstructor(@NonNull Class<E> clazz, Class ... parameterTypes) {
        return Reflects.getConstructor(clazz, parameterTypes) != null;
    }

    public static <E> Constructor<E> getConstructor(@NonNull Class<E> clazz, Class ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public static <E> E newInstance(@NonNull Class<E> clazz) {
        Preconditions.checkNotNull(clazz);
        try {
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Create {} instance fail", (Object)Reflects.getFQNClassName(clazz), (Object)ex);
            }
            return null;
        }
    }

    public static <E> E newInstance(@NonNull Class<E> clazz, @Nullable Class[] parameterTypes, Object ... parameters) {
        Preconditions.checkNotNull(clazz);
        Constructor<E> constructor = Reflects.getConstructor(clazz, parameterTypes);
        if (constructor != null) {
            return Reflects.newInstance(constructor, parameters);
        }
        return null;
    }

    public static <E> E newInstance(@NonNull Constructor<E> constructor, Object ... parameters) {
        Preconditions.checkNotNull(constructor, "the constructor is null");
        try {
            return constructor.newInstance(parameters);
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Create {} instance fail", (Object)Reflects.getFQNClassName(constructor.getDeclaringClass()), (Object)ex);
            }
            return null;
        }
    }

    public static List<Method> getAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> clazz = type;
        while (!Object.class.equals(clazz)) {
            Method[] currentClassMethods;
            for (Method method : currentClassMethods = clazz.getDeclaredMethods()) {
                if (annotation != null && !method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static Method getPublicMethod(@NonNull Class clazz, @NonNull String methodName, Class ... parameterTypes) {
        Method method;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    public static Method getDeclaredMethod(@NonNull Class clazz, @NonNull String methodName, Class ... parameterTypes) {
        Method method;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    public static Method getAnyMethod(@NonNull Class clazz, @NonNull String methodName, Class ... parameterTypes) {
        Method method = Reflects.getDeclaredMethod(clazz, methodName, parameterTypes);
        if (method == null) {
            Class parent = clazz.getSuperclass();
            if (parent != null) {
                return Reflects.getAnyMethod(parent, methodName, parameterTypes);
            }
            return null;
        }
        return method;
    }

    public static <V> V invokePublicMethodForcedIfPresent(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters) {
        try {
            return Reflects.invokePublicMethod(object, methodName, parameterTypes, parameters, true, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V invokePublicMethod(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters, boolean force, boolean throwException) {
        try {
            Method method = Reflects.getPublicMethod(object.getClass(), methodName, parameterTypes);
            if (method == null) {
                if (throwException) {
                    throw new NoSuchMethodException(new ExceptionMessage("Can't find the method: {0}", Reflects.getMethodString(Reflects.getFQNClassName(object.getClass()), methodName, null, parameterTypes)).getMessage());
                }
                return null;
            }
            return Reflects.invokeMethodOrNull(method, object, parameters, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V invokeDeclaredMethodForcedIfPresent(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters) {
        try {
            return Reflects.invokeDeclaredMethod(object, methodName, parameterTypes, parameters, true, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V invokeDeclaredMethod(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters, boolean force, boolean throwException) {
        try {
            Method method = Reflects.getDeclaredMethod(object.getClass(), methodName, parameterTypes);
            if (method == null) {
                if (throwException) {
                    throw new NoSuchMethodException(new ExceptionMessage("Can't find the method: {0}", Reflects.getMethodString(Reflects.getFQNClassName(object.getClass()), methodName, null, parameterTypes)).getMessage());
                }
                return null;
            }
            return Reflects.invokeMethodOrNull(method, object, parameters, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V invokeAnyMethodForcedIfPresent(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters) {
        try {
            return Reflects.invokeAnyMethod(object, methodName, parameterTypes, parameters, true, false);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <V> V invokeAnyMethod(@NonNull Object object, @NonNull String methodName, @Nullable Class[] parameterTypes, @Nullable Object[] parameters, boolean force, boolean throwException) {
        try {
            Method method = Reflects.getAnyMethod(object.getClass(), methodName, parameterTypes);
            if (method == null) {
                if (throwException) {
                    throw new NoSuchMethodException(new ExceptionMessage("Can't find the method: {0}", Reflects.getMethodString(Reflects.getFQNClassName(object.getClass()), methodName, null, parameterTypes)).getMessage());
                }
                return null;
            }
            return Reflects.invokeMethodOrNull(method, object, parameters, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V invoke(@NonNull Method method, @Nullable Object object, @Nullable Object[] parameters, boolean force, boolean throwException) {
        try {
            if (!force && !method.isAccessible()) {
                if (throwException) {
                    throw new IllegalAccessException(new ExceptionMessage("Method {0} is not accessible", method.toString()).getMessage());
                }
                return null;
            }
            if (method.isAccessible()) {
                return Reflects.invokeMethodOrNull(method, object, parameters, throwException);
            }
            method.setAccessible(true);
            return Reflects.invokeMethodOrNull(method, object, parameters, throwException);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static <V> V invokeGetterOrFiled(Object object, String field, boolean force, boolean throwException) {
        Preconditions.checkNotNull(object, "the object is null");
        Preconditions.checkNotEmpty(field, "the field name is null or empty");
        Method method = Reflects.getGetter(object.getClass(), field);
        if (method != null) {
            return Reflects.invoke(method, object, new Object[0], force, throwException);
        }
        return Reflects.getAnyFieldValue(object, field, force, throwException);
    }

    private static <V> V invokeMethodOrNull(@NonNull Method method, @NonNull Object object, @Nullable Object[] parameters, boolean throwException) throws IllegalAccessException, InvocationTargetException {
        try {
            return (V)method.invoke(object, parameters);
        }
        catch (IllegalAccessException ex) {
            if (throwException) {
                throw ex;
            }
            return null;
        }
        catch (InvocationTargetException ex) {
            if (throwException) {
                throw ex;
            }
            return null;
        }
    }

    public static <V> V invokeAnyStaticMethod(String clazz, String methodName, Class[] parameterTypes, Object[] parameters, boolean force, boolean throwException) throws ClassNotFoundException {
        return Reflects.invokeAnyStaticMethod(Class.forName(clazz), methodName, parameterTypes, parameters, force, throwException);
    }

    public static <V> V invokeAnyStaticMethod(Class clazz, String methodName, Class[] parameterTypes, Object[] parameters, boolean force, boolean throwException) {
        try {
            Method method = Reflects.getAnyMethod(clazz, methodName, parameterTypes);
            if (method == null) {
                throw new NoSuchMethodException();
            }
            if (Modifiers.isStatic(method)) {
                return Reflects.invoke(method, null, parameters, force, throwException);
            }
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
        return null;
    }

    public static String getMethodString(@Nullable String clazzFQN, @NonNull String methodName, @Nullable Class returnType, @Nullable Class[] parameterTypes) {
        try {
            StringBuilder sb = new StringBuilder();
            if (returnType != null) {
                sb.append(Reflects.getTypeName(returnType) + " ");
            }
            if (Strings.isNotBlank(clazzFQN)) {
                sb.append(clazzFQN + ".");
            }
            sb.append(methodName + "(");
            if (!Emptys.isEmpty(parameterTypes)) {
                Class[] params = parameterTypes;
                for (int j = 0; j < params.length; ++j) {
                    sb.append(Reflects.getTypeName(params[j]));
                    if (j >= params.length - 1) continue;
                    sb.append(",");
                }
            }
            sb.append(")");
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String getMethodString(Method method) {
        return method.toString();
    }

    public static String getMethodString(@NonNull Class clazz, @NonNull String methodName, @Nullable Class[] parameterTypes) {
        Method method = Reflects.getAnyMethod(clazz, methodName, parameterTypes);
        if (method != null) {
            return Reflects.getMethodString(method);
        }
        return Reflects.getMethodString(Reflects.getTypeName(clazz), methodName, null, parameterTypes);
    }

    public static MethodParameter getMethodParameter(String supplierName, Method method, int index) {
        return PARAMETER_SERVICE_REGISTRY.getMethodParameter(supplierName, method, index);
    }

    public static MethodParameter getMethodParameter(Method method, int index) {
        return PARAMETER_SERVICE_REGISTRY.getMethodParameter(method, index);
    }

    public static List<MethodParameter> getMethodParameters(String supplierName, Method method) {
        return PARAMETER_SERVICE_REGISTRY.getMethodParameters(supplierName, method);
    }

    public static List<MethodParameter> getMethodParameters(Method method) {
        return PARAMETER_SERVICE_REGISTRY.getMethodParameters(method);
    }

    public static ConstructorParameter getConstructorParameter(String supplierName, Constructor constructor, int index) {
        return PARAMETER_SERVICE_REGISTRY.getConstructorParameter(supplierName, constructor, index);
    }

    public static ConstructorParameter getConstructorParameter(Constructor constructor, int index) {
        return PARAMETER_SERVICE_REGISTRY.getConstructorParameter(constructor, index);
    }

    public static List<ConstructorParameter> getConstructorParameters(Constructor constructor) {
        return PARAMETER_SERVICE_REGISTRY.getConstructorParameters(constructor);
    }

    public static List<ConstructorParameter> getConstructorParameters(String supplierName, Constructor constructor) {
        return PARAMETER_SERVICE_REGISTRY.getConstructorParameters(supplierName, constructor);
    }

    public static Set<Class> getAllInterfaces(Class clazz) {
        final HashSet<Class> set = Collects.emptyHashSet(true);
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            Collects.addAll(set, interfaces);
            Collects.forEach(interfaces, new Consumer2<Integer, Class>(){

                @Override
                public void accept(Integer index, Class iface) {
                    set.addAll(Reflects.getAllInterfaces(iface));
                }
            });
        }
        return set;
    }

    public static Set<Class> getAllSuperClass(Class clazz) {
        HashSet<Class> set = Collects.emptyHashSet(true);
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            set.add(superClass);
            set.addAll(Reflects.getAllInterfaces(superClass));
        }
        return set;
    }

    public static String getSetter(String s) {
        char[] chars = new char[s.length() + 3];
        chars[0] = 115;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = Chars.toUpperCase(s.charAt(0));
        for (int i = s.length() - 1; i != 0; --i) {
            chars[i + 3] = s.charAt(i);
        }
        return new String(chars);
    }

    public static String getGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 3];
        chars[0] = 103;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = Chars.toUpperCase(c[0]);
        System.arraycopy(c, 1, chars, 4, c.length - 1);
        return new String(chars);
    }

    public static String getIsGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 2];
        chars[0] = 105;
        chars[1] = 115;
        chars[2] = Chars.toUpperCase(c[0]);
        System.arraycopy(c, 1, chars, 3, c.length - 1);
        return new String(chars);
    }

    public static Method getSetter(Class clazz, String field) {
        String setter = Reflects.getSetter(field);
        for (Method method : clazz.getMethods()) {
            if (!setter.equals(method.getName()) || !Modifiers.isPublic(method) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static Method getSetter(Class clazz, String field, Class parameterType) {
        String setter = Reflects.getSetter(field);
        Method method = Reflects.getDeclaredMethod(clazz, setter, parameterType);
        if (method != null && Modifiers.isPublic(method)) {
            return method;
        }
        return null;
    }

    public static boolean hasGetter(Field field) {
        Method method = Reflects.getGetter(field.getDeclaringClass(), field.getName());
        return method != null && Reflects.isSubClassOrEquals(field.getType(), method.getReturnType());
    }

    public static boolean hasSetter(Field field) {
        Method method = Reflects.getSetter(field.getDeclaringClass(), field.getName());
        return method != null && Reflects.isSubClassOrEquals(field.getType(), method.getParameterTypes()[0]);
    }

    public static Method getGetter(Class clazz, String field) {
        String simple = "get" + field;
        String simpleIsGet = "is" + field;
        String isGet = Reflects.getIsGetter(field);
        String getter = Reflects.getGetter(field);
        Method candidate = null;
        if (Reflects.isSubClassOrEquals(Collection.class, clazz) && "isEmpty".equals(isGet)) {
            try {
                return Collection.class.getMethod("isEmpty", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Method method : clazz.getMethods()) {
            String methodName;
            if (!Modifiers.isPublic(method) || Modifiers.isStatic(method) || method.getParameterTypes().length != 0 || !getter.equals(methodName = method.getName()) && !field.equals(methodName) && (!isGet.equals(methodName) && !simpleIsGet.equals(methodName) || method.getReturnType() != Boolean.TYPE) && !simple.equals(methodName) || candidate != null && !Reflects.isSubClassOrEquals(candidate.getReturnType(), method.getReturnType())) continue;
            candidate = method;
        }
        return candidate;
    }

    public static String extractFieldName(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            return Reflects.extractFieldName((Method)member);
        }
        return null;
    }

    public static String extractFieldName(Method method) {
        if (Reflects.isGetterOrSetter(method)) {
            String methodName = method.getName();
            String fieldName = null;
            if (methodName.startsWith("set") || methodName.startsWith("get")) {
                fieldName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                fieldName = methodName.substring(2);
            }
            return Chars.toLowerCase(fieldName.charAt(0)) + (fieldName.length() > 1 ? fieldName.substring(1) : "");
        }
        return null;
    }

    public static boolean isSetter(@NonNull Method method) {
        if (Reflects.isGetterOrSetter(method)) {
            String methodName = method.getName();
            return methodName.startsWith("set");
        }
        return false;
    }

    public static boolean isGetter(@NonNull Method method) {
        if (Reflects.isGetterOrSetter(method)) {
            String methodName = method.getName();
            return methodName.startsWith("get") || methodName.startsWith("is");
        }
        return false;
    }

    public static boolean isGetterOrSetter(@NonNull Method method) {
        if (method == null) {
            return false;
        }
        if (!Modifiers.isPublic(method) || Modifiers.isStatic(method) || Modifiers.isAbstract(method)) {
            return false;
        }
        String methodName = method.getName();
        String fieldName = null;
        if (methodName.startsWith("set")) {
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            fieldName = methodName.substring(3);
        } else if (methodName.startsWith("get")) {
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            fieldName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            fieldName = methodName.substring(2);
        }
        if (Strings.isEmpty(fieldName)) {
            return false;
        }
        fieldName = fieldName.substring(0, 1).toLowerCase() + (fieldName.length() <= 1 ? "" : fieldName.substring(1));
        Class<?> beanClass = method.getDeclaringClass();
        Field field = Reflects.getAnyField(beanClass, fieldName);
        return field != null;
    }

    public static boolean makeAccessible(@NonNull Field field) {
        try {
            field.setAccessible(true);
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isEqualsMethod(@Nullable Method method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(@Nullable Method method) {
        return method != null && "hashCode".equals(method.getName()) && !method.isVarArgs() && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(@Nullable Method method) {
        return method != null && "toString".equals(method.getName()) && !method.isVarArgs() && method.getParameterTypes().length == 0;
    }

    public static boolean isObjectMethod(@Nullable Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || Reflects.isEqualsMethod(method) || Reflects.isHashCodeMethod(method) || Reflects.isToStringMethod(method));
    }

    public static boolean isOverrideEquals(Class clazz) {
        Method equals = Reflects.getDeclaredMethod(clazz, "equals", Object.class);
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean isOverrideHashCode(Class clazz) {
        Method hashCode = Reflects.getDeclaredMethod(clazz, "hashCode", new Class[0]);
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static boolean isImplementsInterface(@NonNull Class clazz, @NonNull Class intf) {
        Preconditions.checkTrue(intf.isInterface(), "Interface to check was not an interface");
        return Reflects.isSubClassOrEquals(intf, clazz);
    }

    public static boolean isSubClassOrEquals(@NonNull Class parent, @NonNull Class child) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkNotNull(child);
        return parent.isAssignableFrom(child);
    }

    public static boolean isSubClass(@NonNull Class parent, @NonNull Class child) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkNotNull(child);
        return parent != child && Reflects.isSubClassOrEquals(parent, child);
    }

    public static <T> boolean isInstance(T object, String classFQN) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(classFQN);
        Class<?> clazz = object.getClass();
        HashSet set = Collects.emptyHashSet(true);
        Pipeline.of(Reflects.getAllInterfaces(clazz)).concat(Reflects.getAllSuperClass(clazz)).map(new Mapper<Class, String>(){

            @Override
            public String apply(Class ifce) {
                return Reflects.getFQNClassName(ifce);
            }
        }).addTo(set);
        return set.contains(Reflects.getFQNClassName(clazz));
    }

    public static <T> boolean isInstance(T object, @NonNull Class targetType) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(targetType);
        return targetType.isInstance(object);
    }

    public static <E> Class<E> getComponentType(E[] array) {
        Preconditions.checkNotNull(array);
        Class<?> clazz = array.getClass();
        return clazz.getComponentType();
    }
}

