/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pattern.regexp;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.pattern.AbstractPatternMatcher;
import java.util.regex.Pattern;

public class RegExpMatcher
extends AbstractPatternMatcher {
    private String regexp;
    private Pattern pattern;

    public RegExpMatcher() {
    }

    public RegExpMatcher(String regexp) {
        this(regexp, false);
    }

    public RegExpMatcher(String regexp, boolean caseSensitive) {
        this(regexp, caseSensitive, true);
    }

    public RegExpMatcher(String regexp, boolean caseSensitive, boolean trimPattern) {
        this.setPatternExpression(regexp);
        this.setCaseSensitive(caseSensitive);
        this.setTrimPattern(trimPattern);
    }

    @Override
    public void setPatternExpression(String patternExpression) {
        this.regexp = patternExpression;
    }

    @Override
    public boolean match(String string) {
        Preconditions.checkNotEmpty(string, "the string is null or empty");
        Preconditions.checkNotEmpty(this.regexp, "the regexp is null or empty");
        if (this.pattern == null) {
            int flag = 0;
            if (this.caseSensitive) {
                flag |= 2;
            }
            if (this.trimPattern) {
                this.regexp = Strings.trim(this.regexp);
                if (Strings.isEmpty(this.regexp)) {
                    throw new IllegalArgumentException("illegal regexp pattern");
                }
            }
            if (this.global) {
                if (!Strings.startsWith(this.regexp, "^")) {
                    this.regexp = "^" + this.regexp;
                }
                if (!Strings.endsWith(this.regexp, "&")) {
                    this.regexp = this.regexp + "$";
                }
            }
            this.pattern = Pattern.compile(this.regexp, flag);
        }
        if (this.trimPattern) {
            string = Strings.trim(string);
        }
        return this.pattern.matcher(string).matches();
    }
}

