/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Strings;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.os.OS;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger logger = LoggerFactory.getLogger(Platform.class);
    private static final String OSNAME = SystemPropertys.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    public static final boolean isWindows = Platform.isWindows0();
    public static final int JAVA_VERSION_INT = Platform.javaVersion();
    public static final boolean isAndroid = Platform.isAndroid0();
    public static final boolean isKaffeJVM = Platform.isKaffeJVM();
    private static final boolean IS_IVKVM_DOT_NET = Platform.isIkvmDotNet0();
    public static final boolean isGroovyAvailable = Platform.isGroovyAvailable0();
    public static final boolean isMaxOS = OS.isMaxOSX();
    public static final boolean isOSX = Platform.isOSX();
    public static final String processId = Platform.getProcessId0();

    private static boolean isOSX() {
        return OSNAME.startsWith("macosx") || OSNAME.startsWith("osx");
    }

    private static boolean isWindows0() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static boolean isIkvmDotNet0() {
        String vmName = System.getProperty("java.vm.name", "").toUpperCase(Locale.US);
        return "IKVM.NET".equals(vmName);
    }

    private static boolean isAndroid0() {
        String vmName = System.getProperty("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (!isAndroid) {
            String runtime = System.getProperty("java.runtime.name");
            isAndroid = Strings.getEmptyIfNull(runtime).toLowerCase().contains("android");
        }
        if (isAndroid) {
            logger.debug("Platform: Android");
        }
        return isAndroid;
    }

    private static boolean isKaffeJVM() {
        try {
            Class.forName("kaffe.util.NotImplemented");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static int javaVersion() {
        int majorVersion = Platform.isAndroid0() ? 6 : Platform.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)majorVersion);
        return majorVersion;
    }

    private static int majorVersionFromJavaSpecificationVersion() {
        String vm = System.getProperty("java.version");
        if (vm == null) {
            vm = System.getProperty("java.runtime.version");
        }
        if (vm == null) {
            vm = System.getProperty("java.specification.version", "1.6");
        }
        return Platform.majorVersion(vm);
    }

    private static int majorVersion(String javaVersion) {
        int index = Strings.indexOf((CharSequence)javaVersion, (CharSequence)"_", 0);
        if (index != -1) {
            javaVersion = javaVersion.substring(0, index);
        }
        String[] components = javaVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            try {
                version[i] = Integer.parseInt(components[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (version[0] == 1) {
            return version[1];
        }
        return version[0];
    }

    public static boolean is3VMOrGreater() {
        return JAVA_VERSION_INT >= 3;
    }

    public static boolean is4VMOrGreater() {
        return JAVA_VERSION_INT >= 4;
    }

    public static boolean is5VMOrGreater() {
        return JAVA_VERSION_INT >= 5;
    }

    public static boolean is6VMOrGreater() {
        return JAVA_VERSION_INT >= 6;
    }

    public static boolean is7VMOrGreater() {
        return JAVA_VERSION_INT >= 7;
    }

    public static boolean is8VMOrGreater() {
        return JAVA_VERSION_INT >= 8;
    }

    public static boolean is9VMOrGreater() {
        return JAVA_VERSION_INT >= 9;
    }

    public static boolean is10VMOrGreater() {
        return JAVA_VERSION_INT >= 10;
    }

    public static boolean is11VMOrGreater() {
        return JAVA_VERSION_INT >= 11;
    }

    public static boolean is12VMOrGreater() {
        return JAVA_VERSION_INT >= 12;
    }

    public static boolean is13VMOrGreater() {
        return JAVA_VERSION_INT >= 13;
    }

    public static File getJavaExecutable() {
        File binDir;
        String javaHome = null;
        File result = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null != javaHome && (binDir = new File(javaHome, "bin")).isDirectory() && binDir.canRead()) {
            String[] execs = new String[]{"java", "java.exe"};
            for (int i = 0; i < execs.length && !(result = new File(binDir, execs[i])).canRead(); ++i) {
            }
        }
        return result;
    }

    private static boolean isGroovyAvailable0() {
        ClassLoader loader = Platform.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> bindingClass = loader.loadClass("groovy.lang.Binding");
            return bindingClass != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static String getProcessId0() {
        try {
            if (isAndroid) {
                Object runtimeMXBean = Reflects.getDeclaredMethod(Class.forName("java.lang.management.ManagementFactory"), "getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
                return Reflects.getDeclaredMethod(Class.forName("java.lang.management.RuntimeMXBean"), "getName", new Class[0]).invoke(runtimeMXBean, new Object[0]).toString().split("@")[0];
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return runtimeMXBean.getName().split("@")[0];
        }
        catch (Throwable ex) {
            if (isAndroid) {
                try {
                    return new File("/proc/self").getCanonicalFile().getName();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        int end = startPos1 + length;
        while (startPos1 < end) {
            if (bytes1[startPos1] != bytes2[startPos2]) {
                return false;
            }
            ++startPos1;
            ++startPos2;
        }
        return true;
    }

    public static String getTempDirectoryPath() {
        return SystemPropertys.getJavaIOTmpDir();
    }

    public static File getTempDirectory() {
        return new File(Platform.getTempDirectoryPath());
    }

    public static String getUserHomeDirectoryPath() {
        return SystemPropertys.getUserHome();
    }

    public static File getUserHomeDirectory() {
        return new File(Platform.getUserHomeDirectoryPath());
    }

    public static int cpuCore() {
        return Runtime.getRuntime().availableProcessors();
    }
}

