/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.http;

import com.jn.langx.Parser;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.collection.multivalue.LinkedMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMapAccessor;
import com.jn.langx.util.net.http.HttpQueryStrings;

public class HttpQueryStringAccessor
extends BasedStringAccessor<String, String>
implements Parser<String, HttpQueryStringAccessor> {
    private MultiValueMapAccessor delegate;

    public HttpQueryStringAccessor() {
    }

    public HttpQueryStringAccessor(@NonNull String url) {
        this();
        this.setTarget(url);
    }

    public static HttpQueryStringAccessor access(String url) {
        HttpQueryStringAccessor accessor = new HttpQueryStringAccessor();
        accessor.setTarget(url);
        return accessor;
    }

    @Override
    public void setTarget(String url) {
        super.setTarget(url);
        this.delegate = this.parse0(url);
    }

    @Override
    public Object get(String key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean has(String key) {
        return super.has(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.delegate.getString(key, defaultValue);
    }

    private MultiValueMapAccessor parse0(String url) {
        MultiValueMapAccessor accessor = new MultiValueMapAccessor();
        accessor.setTarget(HttpQueryStrings.getQueryStringMultiValueMap(url));
        return accessor;
    }

    @Override
    public HttpQueryStringAccessor parse(String url) {
        this.setTarget(url);
        return this;
    }

    public StringMap getStringMap() {
        MultiValueMap multiValueMap = this.getMultiValueMap();
        StringMap map = new StringMap();
        map.putAll(multiValueMap.toSingleValueMap());
        return map;
    }

    public MultiValueMap getMultiValueMap() {
        if (this.delegate != null) {
            return (MultiValueMap)this.delegate.getTarget();
        }
        return LinkedMultiValueMap.EMPTY;
    }

    @Override
    public void set(String key, Object value) {
        this.delegate.set(key, value);
    }

    @Override
    public void remove(String key) {
        this.delegate.remove(key);
    }
}

