/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.http;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.util.Dates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.StringJoiner;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.LinkedCaseInsensitiveMap;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.multivalue.LinkedMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMapAdapter;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.net.NetworkAddress;
import com.jn.langx.util.net.http.HttpMethod;
import com.jn.langx.util.net.http.HttpRange;
import com.jn.langx.util.net.mime.MediaType;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpHeaders
implements MultiValueMap<String, String>,
Serializable {
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LINK = "Link";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final long serialVersionUID = -8578554704772377436L;
    private static final Pattern ETAG_HEADER_VALUE_PATTERN = Pattern.compile("\\*|\\s*((W\\/)?(\"[^\"]*\"))\\s*,?");
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.ENGLISH);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    final MultiValueMap<String, String> headers;
    private final SimpleDateFormat dateFormatter = Dates.getSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", GMT, Locale.US);
    public static final HttpHeaders EMPTY = new HttpHeaders(new LinkedMultiValueMap<String, String>(0));
    private final SimpleDateFormat[] dateParsers = new SimpleDateFormat[]{Dates.getSimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), Dates.getSimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", GMT, Locale.US)};

    public HttpHeaders() {
        this(new MultiValueMapAdapter<String, String>(new LinkedCaseInsensitiveMap(8, Locale.ENGLISH)));
    }

    public HttpHeaders(MultiValueMap<String, String> headers) {
        Preconditions.checkNotNull(headers, "MultiValueMap must not be null");
        this.headers = headers;
    }

    public static HttpHeaders writableHttpHeaders(HttpHeaders headers) {
        Preconditions.checkNotNull(headers, "HttpHeaders must not be null");
        if (headers == EMPTY) {
            return new HttpHeaders();
        }
        return headers;
    }

    public static String formatHeaders(MultiValueMap<String, String> headers) {
        return "[" + Strings.join(", ", Pipeline.of(headers.entrySet()).map(new Function<Map.Entry<String, Collection<String>>, String>(){

            @Override
            public String apply(Map.Entry<String, Collection<String>> entry) {
                Collection<String> values = entry.getValue();
                return entry.getKey() + ":" + (values.size() == 1 ? "\"" + Collects.asList(values).get(0) + "\"" : Strings.join(", ", Pipeline.of(values).map(new Function<String, String>(){

                    @Override
                    public String apply(String input) {
                        return "\"" + input + "\"";
                    }
                }).asList()));
            }
        }).asList()) + "]";
    }

    public static String encodeBasicAuth(String username, String password, @Nullable Charset charset) {
        CharsetEncoder encoder;
        Preconditions.checkNotNull(username, "Username must not be null");
        Preconditions.checkTrue(!username.contains(":"), "Username must not contain a colon");
        Preconditions.checkNotNull(password, "Password must not be null");
        if (charset == null) {
            charset = Charsets.ISO_8859_1;
        }
        if (!(encoder = charset.newEncoder()).canEncode(username) || !encoder.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + charset.displayName());
        }
        String credentialsString = username + ":" + password;
        byte[] encodedBytes = Base64.encodeBase64(credentialsString.getBytes(charset));
        return new String(encodedBytes, charset);
    }

    public List<String> getOrEmpty(Object headerName) {
        Object values = this.get(headerName);
        return values != null ? Collects.asList(values) : Collects.emptyArrayList();
    }

    public List<MediaType> getAccept() {
        return MediaType.parseMediaTypes(Collects.asList(this.get(ACCEPT)));
    }

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public boolean getAccessControlAllowCredentials() {
        return Boolean.parseBoolean(this.getFirst(ACCESS_CONTROL_ALLOW_CREDENTIALS));
    }

    public void setAccessControlAllowCredentials(boolean allowCredentials) {
        this.set(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.toString(allowCredentials));
    }

    public List<String> getAccessControlAllowHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_ALLOW_HEADERS);
    }

    public void setAccessControlAllowHeaders(List<String> allowedHeaders) {
        this.set(ACCESS_CONTROL_ALLOW_HEADERS, this.toCommaDelimitedString(allowedHeaders));
    }

    public List<HttpMethod> getAccessControlAllowMethods() {
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>();
        String value = this.getFirst(ACCESS_CONTROL_ALLOW_METHODS);
        if (value != null) {
            String[] tokens;
            for (String token : tokens = Strings.split(value, ",")) {
                HttpMethod resolved = HttpMethod.resolve(token);
                if (resolved == null) continue;
                result.add(resolved);
            }
        }
        return result;
    }

    public void setAccessControlAllowMethods(List<HttpMethod> allowedMethods) {
        this.set(ACCESS_CONTROL_ALLOW_METHODS, Strings.join(",", allowedMethods));
    }

    @Nullable
    public String getAccessControlAllowOrigin() {
        return this.getFieldValues(ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlAllowOrigin(@Nullable String allowedOrigin) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_ORIGIN, allowedOrigin);
    }

    public List<String> getAccessControlExposeHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_EXPOSE_HEADERS);
    }

    public void setAccessControlExposeHeaders(List<String> exposedHeaders) {
        this.set(ACCESS_CONTROL_EXPOSE_HEADERS, this.toCommaDelimitedString(exposedHeaders));
    }

    public long getAccessControlMaxAge() {
        String value = this.getFirst(ACCESS_CONTROL_MAX_AGE);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setAccessControlMaxAge(long maxAge) {
        this.set(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge));
    }

    public List<String> getAccessControlRequestHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_REQUEST_HEADERS);
    }

    public void setAccessControlRequestHeaders(List<String> requestHeaders) {
        this.set(ACCESS_CONTROL_REQUEST_HEADERS, this.toCommaDelimitedString(requestHeaders));
    }

    @Nullable
    public HttpMethod getAccessControlRequestMethod() {
        return HttpMethod.resolve(this.getFirst(ACCESS_CONTROL_REQUEST_METHOD));
    }

    public void setAccessControlRequestMethod(@Nullable HttpMethod requestMethod) {
        this.setOrRemove(ACCESS_CONTROL_REQUEST_METHOD, requestMethod != null ? requestMethod.name() : null);
    }

    public List<Charset> getAcceptCharset() {
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens = Strings.split(value, ",");
            ArrayList<Charset> result = new ArrayList<Charset>(tokens.length);
            for (String token : tokens) {
                int paramIdx = token.indexOf(59);
                String charsetName = paramIdx == -1 ? token : token.substring(0, paramIdx);
                if (charsetName.equals("*")) continue;
                result.add(Charset.forName(charsetName));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Charset charset : acceptableCharsets) {
            joiner.add(charset.name().toLowerCase(Locale.ENGLISH));
        }
        this.set(ACCEPT_CHARSET, joiner.toString());
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (Strings.isNotEmpty(value)) {
            String[] tokens = Strings.split(value, ",");
            ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(tokens.length);
            for (String token : tokens) {
                HttpMethod resolved = HttpMethod.resolve(token);
                if (resolved == null) continue;
                result.add(resolved);
            }
            return EnumSet.copyOf(result);
        }
        return EnumSet.noneOf(HttpMethod.class);
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, Strings.join(",", allowedMethods));
    }

    public void setBasicAuth(String username, String password) {
        this.setBasicAuth(username, password, null);
    }

    public void setBasicAuth(String username, String password, @Nullable Charset charset) {
        this.setBasicAuth(HttpHeaders.encodeBasicAuth(username, password, charset));
    }

    public void setBasicAuth(String encodedCredentials) {
        Preconditions.checkNotEmpty(encodedCredentials, "'encodedCredentials' must not be null or blank");
        this.set(AUTHORIZATION, "Basic " + encodedCredentials);
    }

    public void setBearerAuth(String token) {
        this.set(AUTHORIZATION, "Bearer " + token);
    }

    @Nullable
    public String getCacheControl() {
        return this.getFieldValues(CACHE_CONTROL);
    }

    public void setCacheControl(@Nullable String cacheControl) {
        this.setOrRemove(CACHE_CONTROL, cacheControl);
    }

    public List<String> getConnection() {
        return this.getValuesAsList(CONNECTION);
    }

    public void setConnection(String connection) {
        this.set(CONNECTION, connection);
    }

    public void setConnection(List<String> connection) {
        this.set(CONNECTION, this.toCommaDelimitedString(connection));
    }

    @Nullable
    public Locale getContentLanguage() {
        String language = Pipeline.of(this.getValuesAsList(CONTENT_LANGUAGE)).findFirst();
        if (Emptys.isNotEmpty(language)) {
            return new Locale(language);
        }
        return null;
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    @Nullable
    public MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return Strings.isNotEmpty(value) ? MediaType.parseMediaType(value) : null;
    }

    public void setContentType(@Nullable MediaType mediaType) {
        if (mediaType != null) {
            Preconditions.checkTrue(!mediaType.isWildcardType(), "Content-Type cannot contain wildcard type '*'");
            Preconditions.checkTrue(!mediaType.isWildcardSubtype(), "Content-Type cannot contain wildcard subtype '*'");
            this.set(CONTENT_TYPE, mediaType.toString());
        } else {
            this.remove(CONTENT_TYPE);
        }
    }

    @Nullable
    public String getETag() {
        return this.getFirst(ETAG);
    }

    public void setETag(@Nullable String etag) {
        if (etag != null) {
            Preconditions.checkTrue(etag.startsWith("\"") || etag.startsWith("W/"), "Invalid ETag: does not start with W/ or \"");
            Preconditions.checkTrue(etag.endsWith("\""), "Invalid ETag: does not end with \"");
            this.set(ETAG, etag);
        } else {
            this.remove(ETAG);
        }
    }

    @Nullable
    public InetSocketAddress getHost() {
        int separator;
        String value = this.getFirst(HOST);
        if (value == null) {
            return null;
        }
        String host = null;
        int port = 0;
        int n = separator = value.startsWith("[") ? value.indexOf(58, value.indexOf(93)) : value.lastIndexOf(58);
        if (separator != -1) {
            host = value.substring(0, separator);
            String portString = value.substring(separator + 1);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (host == null) {
            host = value;
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public void setHost(@Nullable NetworkAddress host) {
        if (host != null) {
            String value = host.toString();
            this.set(HOST, value);
        } else {
            this.remove(HOST);
        }
    }

    public List<String> getIfMatch() {
        return this.getETagValuesAsList(IF_MATCH);
    }

    public void setIfMatch(String ifMatch) {
        this.set(IF_MATCH, ifMatch);
    }

    public void setIfMatch(List<String> ifMatchList) {
        this.set(IF_MATCH, this.toCommaDelimitedString(ifMatchList));
    }

    public List<String> getIfNoneMatch() {
        return this.getETagValuesAsList(IF_NONE_MATCH);
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.set(IF_NONE_MATCH, ifNoneMatch);
    }

    public void setIfNoneMatch(List<String> ifNoneMatchList) {
        this.set(IF_NONE_MATCH, this.toCommaDelimitedString(ifNoneMatchList));
    }

    @Nullable
    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setLocation(@Nullable URI location) {
        this.setOrRemove(LOCATION, location != null ? location.toASCIIString() : null);
    }

    @Nullable
    public String getOrigin() {
        return this.getFirst(ORIGIN);
    }

    public void setOrigin(@Nullable String origin) {
        this.setOrRemove(ORIGIN, origin);
    }

    @Nullable
    public String getPragma() {
        return this.getFirst(PRAGMA);
    }

    public void setPragma(@Nullable String pragma) {
        this.setOrRemove(PRAGMA, pragma);
    }

    public List<HttpRange> getRange() {
        String value = this.getFirst(RANGE);
        return HttpRange.parseRanges(value);
    }

    public void setRange(List<HttpRange> ranges) {
        String value = HttpRange.toString(ranges);
        this.set(RANGE, value);
    }

    public void setExpires(long time) {
        this.set(EXPIRES, this.dateFormatter.format(new Date(time)));
    }

    public Date getExpires() {
        String value = this.getFirst(EXPIRES);
        if (Strings.isNotEmpty(value)) {
            try {
                Date date = this.dateFormatter.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getUpgrade() {
        return this.getFirst(UPGRADE);
    }

    public void setUpgrade(@Nullable String upgrade) {
        this.setOrRemove(UPGRADE, upgrade);
    }

    public List<String> getVary() {
        return this.getValuesAsList(VARY);
    }

    public void setVary(List<String> requestHeaders) {
        this.set(VARY, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getValuesAsList(String headerName) {
        Object values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (value == null) continue;
                Collections.addAll(result, Strings.split(value, ","));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void clearContentHeaders() {
        this.headers.remove(CONTENT_DISPOSITION);
        this.headers.remove(CONTENT_ENCODING);
        this.headers.remove(CONTENT_LANGUAGE);
        this.headers.remove(CONTENT_LENGTH);
        this.headers.remove(CONTENT_LOCATION);
        this.headers.remove(CONTENT_RANGE);
        this.headers.remove(CONTENT_TYPE);
    }

    protected List<String> getETagValuesAsList(String headerName) {
        Object values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (value == null) continue;
                Matcher matcher = ETAG_HEADER_VALUE_PATTERN.matcher(value);
                while (matcher.find()) {
                    if ("*".equals(matcher.group())) {
                        result.add(matcher.group());
                        continue;
                    }
                    result.add(matcher.group(1));
                }
                if (!result.isEmpty()) continue;
                throw new IllegalArgumentException("Could not parse header '" + headerName + "' with value '" + value + "'");
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    protected String getFieldValues(String headerName) {
        Object headerValues = this.get(headerName);
        return headerValues != null ? this.toCommaDelimitedString((List<String>)headerValues) : null;
    }

    protected String toCommaDelimitedString(List<String> headerValues) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String val : headerValues) {
            if (val == null) continue;
            joiner.add(val);
        }
        return joiner.toString();
    }

    private void setOrRemove(String headerName, @Nullable String headerValue) {
        if (headerValue != null) {
            this.set(headerName, headerValue);
        } else {
            this.remove(headerName);
        }
    }

    @Override
    @Nullable
    public String getFirst(String headerName) {
        return this.headers.getFirst(headerName);
    }

    @Override
    public void add(String headerName, @Nullable String headerValue) {
        this.headers.add(headerName, headerValue);
    }

    @Override
    public void addAll(String key, Collection<? extends String> values) {
        this.headers.addAll(key, values);
    }

    @Override
    public void addAll(MultiValueMap<String, String> values) {
        this.headers.addAll(values);
    }

    @Override
    public void set(String headerName, @Nullable String headerValue) {
        this.headers.set(headerName, headerValue);
    }

    @Override
    public void setAll(Map<String, String> values) {
        this.headers.setAll(values);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    @Override
    public Map<String, List<String>> toMap() {
        return this.headers.toMap();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    @Nullable
    public List<String> get(Object key) {
        Collection vs = (Collection)this.headers.get(key);
        if (vs == null) {
            return null;
        }
        return Collects.asList(vs);
    }

    @Override
    public Collection<String> put(String key, Collection<String> value) {
        return this.headers.put(key, (String)((Object)value));
    }

    @Override
    public Collection<String> remove(Object key) {
        return (Collection)this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Collection<String>> map) {
        this.headers.putAll(map);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<Collection<String>> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, Collection<String>>> entrySet() {
        return this.headers.entrySet();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        HttpHeaders otherHeaders = (HttpHeaders)other;
        return this.headers.equals(otherHeaders.headers);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this.headers);
    }

    @Override
    public void addIfAbsent(String key, String value) {
        if (!this.containsKey(key)) {
            this.add(key, value);
        }
    }

    @Override
    public int total() {
        return this.headers.total();
    }
}

