/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.http;

import com.jn.langx.util.Objs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpAcceptLanguageHeaderTokenizer
implements Iterator {
    private static final String LOCALE_SEPARATOR = ",";
    private static final char QUALITY_SEPARATOR = ';';
    private static final Float DEFAULT_QUALITY = Float.valueOf(1.0f);
    private ArrayList locales = new ArrayList(3);

    public HttpAcceptLanguageHeaderTokenizer(String header) {
        StringTokenizer tok = new StringTokenizer(header, LOCALE_SEPARATOR);
        while (tok.hasMoreTokens()) {
            AcceptLanguage acceptLang = new AcceptLanguage();
            String element = tok.nextToken().trim();
            int index = element.indexOf(59);
            if (index != -1) {
                String q = element.substring(index);
                element = element.substring(0, index);
                index = q.indexOf(61);
                if (index != -1) {
                    try {
                        acceptLang.quality = Float.valueOf(q.substring(index + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            acceptLang.locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
            this.locales.add(acceptLang);
        }
        Collections.sort(this.locales, Collections.reverseOrder());
    }

    @Override
    public boolean hasNext() {
        return !this.locales.isEmpty();
    }

    public Object next() {
        if (this.locales.isEmpty()) {
            throw new NoSuchElementException();
        }
        return ((AcceptLanguage)this.locales.remove((int)0)).locale;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support remove()");
    }

    static /* synthetic */ Float access$100() {
        return DEFAULT_QUALITY;
    }

    private static class AcceptLanguage
    implements Comparable {
        Locale locale;
        Float quality = HttpAcceptLanguageHeaderTokenizer.access$100();

        private AcceptLanguage() {
        }

        public final int compareTo(Object acceptLang) {
            return this.quality.compareTo(((AcceptLanguage)acceptLang).quality);
        }

        public boolean equals(Object acceptLang) {
            if (acceptLang == null) {
                return false;
            }
            if (acceptLang == this) {
                return true;
            }
            if (acceptLang.getClass() != this.getClass()) {
                return false;
            }
            AcceptLanguage ac = (AcceptLanguage)acceptLang;
            if (!Objs.equals(this.locale, ac.locale)) {
                return false;
            }
            return Objs.equals(this.quality, ac.quality);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + this.quality.hashCode();
            return result;
        }
    }
}

