/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import java.net.URLConnection;
import java.util.Date;

public class URLConnections {
    public static long getHeaderFieldLong(URLConnection conn, String name, long defaultValue) {
        try {
            String value = conn.getHeaderField(name);
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int getHeaderFieldInt(URLConnection conn, String name, int defaultValue) {
        try {
            String value = conn.getHeaderField(name);
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getHeaderFieldDate(URLConnection conn, String name, long defaultValue) {
        try {
            String value = conn.getHeaderField(name);
            return Date.parse(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int getContentLength(URLConnection conn) {
        long l = URLConnections.getContentLengthLong(conn);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long getContentLengthLong(URLConnection conn) {
        long l = URLConnections.getHeaderFieldLong(conn, "content-length", -1L);
        if (l > Integer.MAX_VALUE) {
            return -1L;
        }
        if (l < 0L) {
            l = conn.getContentLength();
        }
        return (int)l;
    }

    public static String getContentType(URLConnection conn) {
        return URLConnections.getHeaderField(conn, "content-type");
    }

    public static String getContentEncoding(URLConnection conn) {
        return URLConnections.getHeaderField(conn, "content-encoding");
    }

    public static long getExpiration(URLConnection conn) {
        return URLConnections.getHeaderFieldDate(conn, "expires", 0L);
    }

    public static long getDate(URLConnection conn) {
        return URLConnections.getHeaderFieldDate(conn, "date", 0L);
    }

    public static long getLastModified(URLConnection conn) {
        return URLConnections.getHeaderFieldDate(conn, "last-modified", 0L);
    }

    public static String getHeaderField(URLConnection conn, String name) {
        return conn.getHeaderField(name);
    }
}

