/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import com.jn.langx.Parser;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.net.NetworkAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAddressParser
implements Parser<String, List<NetworkAddress>> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterAddressParser.class);
    private int defaultPort = -1;

    public ClusterAddressParser() {
    }

    public ClusterAddressParser(int defaultPort) {
        this.setDefaultPort(defaultPort);
    }

    public static String normalize(List<NetworkAddress> addresses, final ClusterAddressStyle style) {
        Preconditions.checkNotEmpty(addresses);
        final StringBuilder builder = new StringBuilder(256);
        Collects.forEach(addresses, new Consumer2<Integer, NetworkAddress>(){

            @Override
            public void accept(Integer index, NetworkAddress address) {
                if (index > 0) {
                    builder.append(",");
                }
                if (style == ClusterAddressStyle.HOST_PORT_PAIR) {
                    builder.append(address.getHost() + ":" + address.getPort());
                } else if (style == ClusterAddressStyle.PORT_AT_END) {
                    builder.append(address.getHost());
                }
            }
        });
        if (style == ClusterAddressStyle.PORT_AT_END) {
            builder.append(":" + addresses.get(addresses.size() - 1).getPort());
        }
        return builder.toString();
    }

    @Override
    public List<NetworkAddress> parse(String s) {
        int unifiedPort;
        String[] segments;
        if (Strings.isBlank(s)) {
            return Collections.emptyList();
        }
        LinkedList<NetworkAddress> ret = new LinkedList<NetworkAddress>();
        for (String segment : segments = Strings.split(s, ",")) {
            String[] ipSegments = (segment = Strings.strip(segment)).split(":");
            if (ipSegments.length < 1) continue;
            if (ipSegments.length == 1) {
                ret.add(new NetworkAddress(ipSegments[0], 0));
                continue;
            }
            if (ipSegments.length == 2) {
                try {
                    int port = Integer.parseInt(ipSegments[1]);
                    ret.add(new NetworkAddress(ipSegments[0], port));
                }
                catch (NumberFormatException ex) {
                    logger.error("not a illegal address string: {}", (Object)s);
                }
                continue;
            }
            if (ipSegments.length == 3 && segment.contains("::")) {
                ret.add(new NetworkAddress(segment, 0));
                continue;
            }
            if (ipSegments.length == 4 && segment.contains("::")) {
                ret.add(new NetworkAddress(segment, 0));
                continue;
            }
            if (ipSegments.length == 8) {
                ret.add(new NetworkAddress(segment, 0));
                continue;
            }
            if (ipSegments.length == 9) {
                try {
                    int port = Integer.parseInt(ipSegments[ipSegments.length - 1]);
                    ret.add(new NetworkAddress(segment.substring(0, segment.lastIndexOf(":")), port));
                }
                catch (NumberFormatException ex) {
                    logger.error("not a illegal address string: {}", (Object)s);
                }
                continue;
            }
            logger.error("not a illegal address string: {}", (Object)s);
        }
        int firstValidPortIndex = Collects.firstOccurrence(ret, new Predicate2<Integer, NetworkAddress>(){

            @Override
            public boolean test(Integer index, NetworkAddress address) {
                return address.getPort() > 0;
            }
        });
        boolean useUnifiedPortInAddressString = firstValidPortIndex == ret.size() - 1;
        int n = unifiedPort = useUnifiedPortInAddressString ? ((NetworkAddress)ret.get(ret.size() - 1)).getPort() : this.defaultPort;
        if (unifiedPort > 0) {
            Collects.forEach(ret, new Predicate<NetworkAddress>(){

                @Override
                public boolean test(NetworkAddress address) {
                    return address.getPort() < 1;
                }
            }, new Consumer<NetworkAddress>(){

                @Override
                public void accept(NetworkAddress address) {
                    address.setPort(unifiedPort);
                }
            });
        }
        return ret;
    }

    public String normalize(String s, ClusterAddressStyle style) {
        List<NetworkAddress> addresses = this.parse(s);
        if (Emptys.isEmpty(addresses)) {
            return "";
        }
        return ClusterAddressParser.normalize(addresses, style);
    }

    public String normalize(String s) {
        return this.normalize(s, ClusterAddressStyle.HOST_PORT_PAIR);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public static enum ClusterAddressStyle {
        HOST_PORT_PAIR,
        PORT_AT_END;

    }
}

