/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.memory.objectsize;

import com.jn.langx.cache.AbstractCacheLoader;
import com.jn.langx.cache.Cache;
import com.jn.langx.cache.CacheBuilder;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.IdentityHashSet;
import com.jn.langx.util.memory.objectsize.Arch32MemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.Arch64CompressedMemoryLayoutSpecified;
import com.jn.langx.util.memory.objectsize.Arch64UncompressedMemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.MemoryLayoutSpecification;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;

public class ObjectSizeCalculator {
    private final int arrayHeaderSize;
    private final int objectHeaderSize;
    private final int objectPadding;
    private final int referenceSize;
    private final int superclassFieldPadding;
    private final Cache<Class<?>, ClassSizeInfo> classSizeInfos = CacheBuilder.newBuilder().loader(new AbstractCacheLoader<Class<?>, ClassSizeInfo>(){

        @Override
        public ClassSizeInfo load(Class<?> clazz) {
            return new ClassSizeInfo(clazz);
        }
    }).build();
    private final Set<Object> alreadyVisited = new IdentityHashSet<Object>();
    private final Deque<Object> pending = new ArrayDeque<Object>(16384);
    private long size;

    public static long getObjectSize(Object obj) throws UnsupportedOperationException {
        return obj == null ? 0L : new ObjectSizeCalculator(CurrentLayout.SPEC).calculateObjectSize(obj);
    }

    public ObjectSizeCalculator(MemoryLayoutSpecification memoryLayoutSpecification) {
        Preconditions.checkNotNull(memoryLayoutSpecification);
        this.arrayHeaderSize = memoryLayoutSpecification.getArrayHeaderSize();
        this.objectHeaderSize = memoryLayoutSpecification.getObjectHeaderSize();
        this.objectPadding = memoryLayoutSpecification.getObjectPadding();
        this.referenceSize = memoryLayoutSpecification.getReferenceSize();
        this.superclassFieldPadding = memoryLayoutSpecification.getSuperclassFieldPadding();
    }

    public synchronized long calculateObjectSize(Object obj) {
        try {
            while (true) {
                this.visit(obj);
                if (this.pending.isEmpty()) {
                    long l = this.size;
                    return l;
                }
                obj = this.pending.removeFirst();
            }
        }
        finally {
            this.alreadyVisited.clear();
            this.pending.clear();
            this.size = 0L;
        }
    }

    private void visit(Object obj) {
        if (this.alreadyVisited.contains(obj)) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == ArrayElementsVisitor.class) {
            ((ArrayElementsVisitor)obj).visit(this);
        } else {
            this.alreadyVisited.add(obj);
            if (clazz.isArray()) {
                this.visitArray(obj);
            } else {
                this.classSizeInfos.get(clazz).visit(obj, this);
            }
        }
    }

    private void visitArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        if (componentType.isPrimitive()) {
            this.increaseByArraySize(length, ObjectSizeCalculator.getPrimitiveFieldSize(componentType));
        } else {
            this.increaseByArraySize(length, this.referenceSize);
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.enqueue(Array.get(array, 0));
                    break;
                }
                default: {
                    this.enqueue(new ArrayElementsVisitor((Object[])array));
                }
            }
        }
    }

    private void increaseByArraySize(int length, long elementSize) {
        this.increaseSize(ObjectSizeCalculator.roundTo((long)this.arrayHeaderSize + (long)length * elementSize, this.objectPadding));
    }

    void enqueue(Object obj) {
        if (obj != null) {
            this.pending.addLast(obj);
        }
    }

    void increaseSize(long objectSize) {
        this.size += objectSize;
    }

    static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    private static long getPrimitiveFieldSize(Class<?> type) {
        return Primitives.sizeOf(type);
    }

    static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null || !vmName.startsWith("Java HotSpot(TM) ") && !vmName.startsWith("OpenJDK") && !vmName.startsWith("TwitterJDK")) {
            throw new UnsupportedOperationException("ObjectSizeCalculator only supported on HotSpot VM");
        }
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new Arch32MemoryLayoutSpecification();
        }
        if (!"64".equals(dataModel)) {
            throw new UnsupportedOperationException("Unrecognized value '" + dataModel + "' of sun.arch.data.model system property");
        }
        String strVmVersion = System.getProperty("java.vm.version");
        int vmVersion = Integer.parseInt(strVmVersion.substring(0, strVmVersion.indexOf(46)));
        if (vmVersion >= 17) {
            long maxMemory = 0L;
            for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                maxMemory += mp.getUsage().getMax();
            }
            if (maxMemory < 0x780000000L) {
                return new Arch64CompressedMemoryLayoutSpecified();
            }
        }
        return new Arch64UncompressedMemoryLayoutSpecification();
    }

    private class ClassSizeInfo {
        private final long objectSize;
        private final long fieldsSize;
        private final Field[] referenceFields;

        public ClassSizeInfo(Class<?> clazz) {
            long fieldsSize = 0L;
            LinkedList<Field> referenceFields = new LinkedList<Field>();
            for (Field f : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                Class<?> type = f.getType();
                if (type.isPrimitive()) {
                    fieldsSize += ObjectSizeCalculator.getPrimitiveFieldSize(type);
                    continue;
                }
                f.setAccessible(true);
                referenceFields.add(f);
                fieldsSize += (long)ObjectSizeCalculator.this.referenceSize;
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                ClassSizeInfo superClassInfo = (ClassSizeInfo)ObjectSizeCalculator.this.classSizeInfos.get(superClass);
                fieldsSize += ObjectSizeCalculator.roundTo(superClassInfo.fieldsSize, ObjectSizeCalculator.this.superclassFieldPadding);
                referenceFields.addAll(Arrays.asList(superClassInfo.referenceFields));
            }
            this.fieldsSize = fieldsSize;
            this.objectSize = ObjectSizeCalculator.roundTo((long)ObjectSizeCalculator.this.objectHeaderSize + fieldsSize, ObjectSizeCalculator.this.objectPadding);
            this.referenceFields = referenceFields.toArray(new Field[referenceFields.size()]);
        }

        void visit(Object obj, ObjectSizeCalculator calc) {
            calc.increaseSize(this.objectSize);
            this.enqueueReferencedObjects(obj, calc);
        }

        public void enqueueReferencedObjects(Object obj, ObjectSizeCalculator calc) {
            for (Field f : this.referenceFields) {
                try {
                    calc.enqueue(f.get(obj));
                }
                catch (IllegalAccessException e) {
                    AssertionError ae = new AssertionError((Object)("Unexpected denial of access to " + f));
                    ((Throwable)((Object)ae)).initCause(e);
                    throw ae;
                }
            }
        }
    }

    private static class ArrayElementsVisitor {
        private final Object[] array;

        ArrayElementsVisitor(Object[] array) {
            this.array = array;
        }

        public void visit(ObjectSizeCalculator calc) {
            for (Object elem : this.array) {
                if (elem == null) continue;
                calc.visit(elem);
            }
        }
    }

    private static class CurrentLayout {
        private static final MemoryLayoutSpecification SPEC = ObjectSizeCalculator.getEffectiveMemoryLayoutSpecification();

        private CurrentLayout() {
        }
    }
}

