/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.memory.leak;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.memory.leak.DefaultResourceLeakDetectorFactory;
import com.jn.langx.util.memory.leak.ResourceLeakDetector;

public abstract class ResourceLeakDetectorFactory {
    private static volatile ResourceLeakDetectorFactory FACTORY_INSTANCE = new DefaultResourceLeakDetectorFactory();

    public static ResourceLeakDetectorFactory instance() {
        return FACTORY_INSTANCE;
    }

    public static void setResourceLeakDetectorFactory(ResourceLeakDetectorFactory factory) {
        FACTORY_INSTANCE = Preconditions.checkNotNull(factory, "factory");
    }

    public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource) {
        return this.newResourceLeakDetector(resource, ResourceLeakDetector.SAMPLING_INTERVAL);
    }

    public abstract <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> var1, int var2);
}

