/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jar;

import com.jn.langx.util.jar.multiplelevel.JarFile;
import com.jn.langx.util.jar.multiplelevel.MultipleLevelURLStreamHandler;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;

public class MultipleLevelJarUrlClassLoader
extends URLClassLoader {
    static Method classLoader_RegisterAsParallelCapable_method;

    public MultipleLevelJarUrlClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL findResource(String name) {
        MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(true);
        try {
            URL uRL = super.findResource(name);
            return uRL;
        }
        finally {
            MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(true);
        try {
            UseFastConnectionExceptionsEnumeration useFastConnectionExceptionsEnumeration = new UseFastConnectionExceptionsEnumeration(super.findResources(name));
            return useFastConnectionExceptionsEnumeration;
        }
        finally {
            MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(true);
        try {
            block5: {
                try {
                    this.definePackageIfNecessary(name);
                }
                catch (IllegalArgumentException ex) {
                    if (this.getPackage(name) != null) break block5;
                    throw new AssertionError((Object)("Package " + name + " has already been defined but it could not be found"));
                }
            }
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(false);
        }
    }

    private void definePackageIfNecessary(String className) {
        block3: {
            String packageName;
            int lastDot = className.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(packageName = className.substring(0, lastDot)) == null) {
                try {
                    this.definePackage(className, packageName);
                }
                catch (IllegalArgumentException ex) {
                    if (this.getPackage(packageName) != null) break block3;
                    throw new AssertionError((Object)("Package " + packageName + " has already been defined but it could not be found"));
                }
            }
        }
    }

    private void definePackage(final String className, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    String packageEntryName = packageName.replace('.', '/') + "/";
                    String classEntryName = className.replace('.', '/') + ".class";
                    for (URL url : MultipleLevelJarUrlClassLoader.this.getURLs()) {
                        try {
                            java.util.jar.JarFile jarFile;
                            URLConnection connection = url.openConnection();
                            if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            MultipleLevelJarUrlClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void clearCache() {
        for (URL url : this.getURLs()) {
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                this.clearCache(connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearCache(URLConnection connection) throws IOException {
        java.util.jar.JarFile jarFile = ((JarURLConnection)connection).getJarFile();
        if (jarFile instanceof JarFile) {
            ((JarFile)jarFile).clearCache();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    static {
        Method m = Reflects.getDeclaredMethod(ClassLoader.class, "registerAsParallelCapable", new Class[0]);
        if (m != null) {
            classLoader_RegisterAsParallelCapable_method = m;
        }
    }

    private static class UseFastConnectionExceptionsEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> delegate;

        UseFastConnectionExceptionsEnumeration(Enumeration<URL> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasMoreElements() {
            MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(true);
            try {
                boolean bl = this.delegate.hasMoreElements();
                return bl;
            }
            finally {
                MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(false);
            }
        }

        @Override
        public URL nextElement() {
            MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(true);
            try {
                URL uRL = this.delegate.nextElement();
                return uRL;
            }
            finally {
                MultipleLevelURLStreamHandler.setUseFastConnectionExceptions(false);
            }
        }
    }
}

